% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best.pair.R
\name{best.pair}
\alias{best.pair}
\title{NPI for comparing two groups}
\usage{
best.pair(X, Y)
}
\arguments{
\item{X}{numeric vector of data values}

\item{Y}{numeric vector of data values, to check if it is the best group}
}
\value{
NPI lower and upper probabilities for the event that the next future observation from group  Y is larger than the next future observation from group  X.
}
\description{
NPI lower and upper probabilities for the event that the next future observation from group  Y is larger than the next future observation from group  X.
}
\examples{
data(BreakdownTimes)
data2<-split(BreakdownTimes$times, BreakdownTimes$group)
# No terminated tails, complete data
best.pair(data2$X, data2$Y)
}
\references{
F.P.A. Coolen (1996). Comparing two populations based on low stochastic structure assumptions. Statistics & Probability Letters 29, 297-305.
}
