% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFAR.r
\name{g_cfar}
\alias{g_cfar}
\title{Generate a CFAR Process}
\usage{
g_cfar(
  tmax = 1001,
  rho = 5,
  phi_list = NULL,
  grid = 1000,
  sigma = 1,
  ini = 100
)
}
\arguments{
\item{tmax}{length of time.}

\item{rho}{parameter for O-U process (noise process).}

\item{phi_list}{the convolutional function(s). Default is the density function of normal distribution with mean 0 and standard deviation 0.1.}

\item{grid}{the number of grid points used to construct the functional time series. Default is 1000.}

\item{sigma}{the standard deviation of O-U process. Default is 1.}

\item{ini}{the burn-in period.}
}
\value{
The function returns a list with components:
\item{cfar}{a tmax-by-(grid+1) matrix following a CFAR(p) process.}
\item{epsilon}{the innovation at time tmax.}
}
\description{
Generate a convolutional functional autoregressive process.
}
\references{
Liu, X., Xiao, H., and Chen, R. (2016) Convolutional autoregressive models for functional time series. \emph{Journal of Econometrics}, 194, 263-282.
}
