% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngrams_dictionary.R
\name{ngrams_dictionary}
\alias{ngrams_dictionary}
\title{Create n-grams dictionary}
\usage{
ngrams_dictionary(
  texts,
  clean = TRUE,
  ngram_min = 1,
  ngram_max = 5,
  points_filter = 1
)
}
\arguments{
\item{texts}{character vector, these are the texts used to create n-grams
dictionary. Case-sensitive.}

\item{clean}{logical, indicating if the texts should be cleaned before
creating n-grams dictionary.}

\item{ngram_min}{numeric, sets the minimum number of words in creating
the dictionary.}

\item{ngram_max}{numeric, sets the maximum number of words in creating
the dictionary.}

\item{points_filter}{numeric, sets the minimal number of points (occurrences)
of an n-gram to be included in the dictionary.}
}
\value{
The output always will be data.frame with 4 columns: 1) to_search,
2) to_replace, 3) id, 4) points.
}
\description{
\code{ngrams_dictionary} returns the data.frame containing dictionary for
\link{ngrams_segmentation}.
}
\examples{
texts <- c("this is science",
           "science is #fascinatingthing",
           "this is a scientific approach",
           "science is everywhere",
           "the beauty of science")
ngrams_dictionary(texts)
ngrams_dictionary(texts,
                  clean = FALSE)
ngrams_dictionary(texts,
                  clean = TRUE,
                  ngram_min = 2,
                  ngram_max = 2)

}
