% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\name{inCone}
\alias{inCone}
\alias{inCone,agentMatrix,numeric,numeric,matrix-method}
\title{\code{Agents} in cone}
\usage{
inCone(turtles, radius, angle, agents, world, torus = FALSE)

\S4method{inCone}{agentMatrix,numeric,numeric,matrix}(turtles, radius, angle, agents, world, torus = FALSE)
}
\arguments{
\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}

\item{radius}{Numeric. Vector of distances from \code{turtles} to locate
\code{agents}. Must be of length 1 or of length \code{turtles}.}

\item{angle}{Numeric. Vector of angles to define the size of the cone of vision
for the \code{turtles}. The cone of vision is defined between the
direction of their \code{headings} minus \code{angle / 2}
to the direction of their \code{headings} plus \code{angle / 2}. Must be of
length 1 or
of length \code{turtles}.}

\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
column \code{pycor} representing the \code{patches} coordinates, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{          `AgentMatrix` object representing the moving `agents`.
}\if{html}{\out{</div>}}}

\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{torus}{Logical to determine if the \code{world} is wrapped. Default is
\code{torus = FALSE}.}
}
\value{
Matrix (\code{ncol} = 3) with the first column \code{pxcor}
and the second column \code{pycor} representing the coordinates of the
\code{patches} among \code{agents2} within the cone of vision of each of the
\code{turtles}
which are represented by the \code{id} column, if
\code{agents} are \code{patches}, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{    Matrix (`ncol` = 2) with the first column `who`
    representing the `who` numbers of the
    `turtles` among `agents2` within the cone of vision of each of  the
    `turtles`
    which are represented by the `id` column, if
    `agents` are `turtles`.
}\if{html}{\out{</div>}}
}
\description{
Report the \code{agents} within the "cone of vision" in front of each one of the
\code{turtles}.
}
\details{
\code{agents} are reported if there are within \code{radius}
distance of the \code{turtle} and their direction from the \code{turtle} is within
\verb{[-angle, + angle]} of the \code{turtle}'s heading.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     Distances to `patches` are calculated to their center.

     If `torus = FALSE`, `world` does not need to be provided.

     If `torus = TRUE`, the `radius` distances are calculated
     around the sides of the `world` to select `agents`.
}\if{html}{\out{</div>}}
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))

if (requireNamespace("sf", quietly = TRUE)) {
  p1 <- inCone(turtles = t1, radius = 2, agents = patches(w1), angle = 90)
  t2 <- inCone(turtles = turtle(t1, who = 0), radius = 2, angle = 90, agents = t1)
}

}
\references{
Wilensky, U. 1999. NetLogo. \url{https://www.netlogo.org}.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://docs.netlogo.org/dictionary.html#in-cone}
}
\author{
Sarah Bauduin
}
