% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_edd.R
\name{nd.edd}
\alias{nd.edd}
\title{Edge Difference Distance}
\usage{
nd.edd(A, out.dist = TRUE)
}
\arguments{
\item{A}{a list of length \eqn{N} containing \eqn{(M\times M)} adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
}
}
\description{
It is of the most simplest form that Edge Difference Distance (EDD)
takestwo adjacency matrices and takes Frobenius norm of their differnces.
}
\examples{
## load example data
data(graph20)

## compute distance matrix
output = nd.edd(graph20, out.dist=FALSE)

## visualize
opar <- par(no.readonly=TRUE)
par(pty="s")
image(output$D[,20:1], main="two group case", axes=FALSE, col=gray(0:32/32))
par(opar)

}
\references{
\insertRef{hammond_graph_2013}{NetworkDistance}
}
