% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InvGenGPZ.r
\name{InvGenGPZ}
\alias{InvGenGPZ}
\alias{dinv.gen.gpz}
\alias{pinv.gen.gpz}
\alias{qinv.gen.gpz}
\alias{rinv.gen.gpz}
\alias{hinv.gen.gpz}
\title{Inverse Generalized Gompertz Distribution}
\usage{
dinv.gen.gpz(x, alpha, lambda, theta, log = FALSE)
pinv.gen.gpz(q, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qinv.gen.gpz(p, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rinv.gen.gpz(n, alpha, lambda, theta)
hinv.gen.gpz(x, alpha, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dinv.gen.gpz}: numeric vector of (log-)densities
  \item \code{pinv.gen.gpz}: numeric vector of probabilities
  \item \code{qinv.gen.gpz}: numeric vector of quantiles
  \item \code{rinv.gen.gpz}: numeric vector of random variates
  \item \code{hinv.gen.gpz}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Inverse Generalized Gompertz distribution.
}
\details{
The Inverse Generalized Gompertz distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\lambda > 0}, and \eqn{\theta > 0}.


The Inverse Generalized Gompertz distribution has CDF:

\deqn{
F(x; \alpha, \lambda, \theta) =
1 - \left[ 1 - \exp\left( \frac{\lambda}{\alpha} \left( 1 - \exp(\alpha / x) \right) \right) \right]^{\theta},
\quad x > 0.
}

where \eqn{\alpha}, \eqn{\lambda}, and \eqn{\theta} are the parameters.

The implementation includes the following functions:
\itemize{
  \item \code{dinv.gen.gpz()} — Density function
  \item \code{pinv.gen.gpz()} — Distribution function
  \item \code{qinv.gen.gpz()} — Quantile function
  \item \code{rinv.gen.gpz()} — Random generation
  \item \code{hinv.gen.gpz()} — Hazard function
}
}
\examples{
x <- seq(2, 5, 0.25)
dinv.gen.gpz(x, 1.5, 2.5, 5.0)
pinv.gen.gpz(x, 1.5, 2.5, 5.0)
qinv.gen.gpz(0.5, 1.5, 2.5, 5.0)
rinv.gen.gpz(10, 1.5, 2.5, 5.0)
hinv.gen.gpz(x, 1.5, 2.5, 5.0)

# Data
x <- fibers63
# ML estimates
params = list(alpha=3.4106, lambda=5.4685, theta=20.9199)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pinv.gen.gpz, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qinv.gen.gpz, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dinv.gen.gpz, pfun=pinv.gen.gpz, plot=TRUE)
print.gofic(out)

}
\references{
Chaudhary, A.K., & Kumar, V. (2017). 
Inverse Generalized Gompertz Distribution with Properties and Applications.
\emph{Journal of National Academy of Mathematics}, \bold{31}, 1--15.
}
