% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogisExpExt.r
\name{LogisExpExt}
\alias{LogisExpExt}
\alias{dlogis.exp.ext}
\alias{plogis.exp.ext}
\alias{qlogis.exp.ext}
\alias{rlogis.exp.ext}
\alias{hlogis.exp.ext}
\title{Logistic-Exponential Extension Distribution}
\usage{
dlogis.exp.ext(x, alpha, beta, lambda, log = FALSE)
plogis.exp.ext(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qlogis.exp.ext(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rlogis.exp.ext(n, alpha, beta, lambda)
hlogis.exp.ext(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlogis.exp.ext}: numeric vector of (log-)densities
  \item \code{plogis.exp.ext}: numeric vector of probabilities
  \item \code{qlogis.exp.ext}: numeric vector of quantiles
  \item \code{rlogis.exp.ext}: numeric vector of random variates
  \item \code{hlogis.exp.ext}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Logistic-Exponential Extension distribution.
}
\details{
The Logistic-Exponential Extension distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Logistic-Exponential Extension distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad 1-\frac{1}{1+\left[\exp \left\{-\lambda x e^{-\beta / x}\right\}
-1\right]^\alpha}  \, ; \, x > 0.
}
 
where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The implementation includes the following functions:
\itemize{
  \item \code{dlogis.exp.ext()} — Density function
  \item \code{plogis.exp.ext()} — Distribution function
  \item \code{qlogis.exp.ext()} — Quantile function
  \item \code{rlogis.exp.ext()} — Random generation
  \item \code{hlogis.exp.ext()} — Hazard function
}
}
\examples{
x <- seq(0.1, 10, 0.2)
dlogis.exp.ext(x, 2.0, 5.0, 0.1)
plogis.exp.ext(x, 2.0, 5.0, 0.1)
qlogis.exp.ext(0.5, 2.0, 5.0, 0.1)
rlogis.exp.ext(10, 2.0, 5.0, 0.1)
hlogis.exp.ext(x, 2.0, 5.0, 0.1)

# Data
x <- stress31
# ML estimates
params = list(alpha=1.7919, beta=418.0473, lambda=0.1211)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plogis.exp.ext, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlogis.exp.ext, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
res <- gofic(x, params = params,
             dfun = dlogis.exp.ext, pfun=plogis.exp.ext, plot=TRUE)
print.gofic(res)

}
\references{
Chaudhary,A.K., & Kumar, V.(2020). 
A Study on Properties and Real Data Applications of the Logistic 
Exponential Extension Distribution with Properties. \emph{International 
Journal of Latest Trends In Engineering and Technology (IJLTET)},
\bold{18(2)}, 20-30.
}
