% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoviceDeveloperResources2.R
\name{PackageDependencies}
\alias{PackageDependencies}
\title{PackageDependencies}
\usage{
PackageDependencies(dir, packs, master, n, verbose)
}
\arguments{
\item{dir}{character string containing the name of the directory holding packs}

\item{packs}{list of package names}

\item{master}{list whose componenets are lists indexed by integer recursion level
the components of each recursion level are the return values of
retrieveNamespace() and reversePackageDependencies()}

\item{n}{integer recursion level}

\item{verbose}{if TRUE print line indicating the recursion level}
}
\value{
returns a list whose components are lists indexed by the integer recursion level:
\item{l}{
return value of retrieveNamespace()
}
\item{ll}{
return value of reversePackageDependencies()
}
}
\description{
recursively call recursivePackageDependencies2() and reversePackageDependencies()
to recursively delete leaf nodes until packs has been depleted to length zero
}
\details{
NOTE that the packages in packs do not need to be loaded or attached to the search() path
}
\examples{
\dontrun{
# you need to specify dir, packs that are on your own computer !!
dir1<-"~/personal/hearts/hearts_card_game_bayesian_inference"
dir2<-"packages/inference_packages/inference_packages/"
packs<-c("cardUtils","clickableImageMap","editDriver",
"heartsCIM","iterationDriver","logos","playOneTrick",
"playWholeHandDriverPassParams","probTab","relaxDriver")
master<-PackageDependencies(sprintf("\%s/\%s",dir1,dir2),packs, vector("list",length(packs)),1,TRUE)
}

}
