% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OBRE.R
\name{OBRE}
\alias{OBRE}
\title{Optimal B-Robust Estimator}
\usage{
OBRE(
  nvData,
  strDistribution,
  nCParOBRE,
  dfParOBRE = data.frame(nEta = 1e-06, nMaxIterLoopWc = 10, nMaxIterLoopA = 10, nRelTol =
    0.001, nAbsTol = 0.5, stringsAsFactors = FALSE),
  nTheta1Init = NA,
  nTheta2Init = NA,
  eDensityFun = NA
)
}
\arguments{
\item{nvData}{The vector of data.}

\item{strDistribution}{The distribution name between "normal" (Normal distribution), "logNormal" (logNormal distribution),
"weibull" (Weibull distribution), "logLogistic" (logLogistic distribution), "gpd2" (Generalized Pareto
Distribution with two parameters) or "custom" if the distribution is written by the user as an input of "eDensityFun" parameter.
Alternatively, the input of "strDistribution" can be an object of class "OBREdist", obtained using function densityExpressions.}

\item{nCParOBRE}{OBRE robustness parameter.}

\item{dfParOBRE}{A data frame containing oprimization parameters, i.e. nEta, the precision
between two parameters optimization, nMaxIterLoopWc and nMaxIterLoopA, the number of iterations in the
optimization proceture, nRelTol and nAbsTol, the relative and absolute tolerances.}

\item{nTheta1Init}{First parameter for the beginning of the computation.}

\item{nTheta2Init}{Second parameter for the beginning of the computation.}

\item{eDensityFun}{The density of a two parameters distribution. To be inserted if in strDistribution the "custom" option is chosen. This should be an expression object, the
two parameters should be called "nTheta1" and "nTheta2", the data "nvData" and its formula should be derivable}
}
\value{
A list with the vector containing the final parameters, the exit OBRE message, the values of vector a and matrix A,
the OBRE tuning parameter c, the initial values of the parameters (if unspecified by the user, the values of MLE are reported),
the vector of data, the density expression.
}
\description{
Function for obtaining the Optimal B-Robust Estimates starting by a vector of data and a
two parameters distribution.
}
\examples{
# Using the densityExpressions function for initialize the distribution
distrForOBRE <- densityExpressions(strDistribution = "normal")
simData = c(rnorm(1000, 12, 2),200,150)
\donttest{try({estOBRE <- OBRE(nvData = simData, strDistribution = distrForOBRE, nCParOBRE = 3)
# Launching the generation of the density expression directly from OBRE
simData = c(rnorm(1000, 12, 2),200,150)
estOBRE <- OBRE(nvData = simData, strDistribution = "normal", nCParOBRE = 3)
# Using the "custom" option and using the normal distribution
simData = c(rnorm(1000, 12, 2),200,150)
estOBRE <- OBRE(nvData = simData, strDistribution = "custom", nCParOBRE = 3,
eDensityFun = expression((exp( -((nvData - nTheta1)^2) / (2 * nTheta2^2)) /
(sqrt(2 * pi) * nTheta2))))})}

}
\references{
Bellio, R. (2007). Algorithms for bounded-influence estimation. Comput. Stat. Data Anal. 51, 2531-2541.

Hampel F (1968). Contributions to the theory of robust estimation. University of California.

Hampel, F., Ronchetti, E., Rousseeuw, P. & Stahel, W. (1985). Robust Statistics. The approach based on influence function. John Wiley and Sons Ltd., Chichester, UK.

Victoria-Feser, M.P. & Ronchetti, E. (1994). Robust methods for personal-income distribution models. Canadian Journal of Statistics 22, 247-258.
}
