% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OPTtesting.R
\name{d_value}
\alias{d_value}
\title{d_value}
\usage{
d_value(
  Z,
  Sigma,
  best_set = AEB(Z, Sigma),
  eig = eigs_sym(Sigma, min(400, length(Z)), which = "LM"),
  sim_size = 3000,
  eig_value = 0.35
)
}
\arguments{
\item{Z}{a vector of test statistics}

\item{Sigma}{covariance matrix}

\item{best_set}{a list of parameters (list(nu_0 = ..., tau_sqr_1 = ..., tau_sqr_2 = ..., pi_0 = ..., pi_1= ..., pi_2 = ..., mu_1 = ..., mu_2 = ...)) or returns from AEB}

\item{eig}{eig value information}

\item{sim_size}{simulation size}

\item{eig_value}{the smallest eigen value used in the calulation}
}
\value{
a vector of estimates for \eqn{P(\mu_i \le 0 | Z), i = 1, ..., p}
}
\description{
Calculating the estimates for \eqn{P(\mu_i \le 0 | Z)}
}
\examples{
p = 500
n_col = 10
A = matrix(rnorm(p*n_col,0,1), nrow = p, ncol = n_col, byrow = TRUE)
Sigma = A \%*\% t(A) +diag(p)
Sigma = cov2cor(Sigma) #covariance matrix
Z = rnorm(p,0,1) #this is just an example for testing the algorithm.
#Not true test statistics with respect to Sigma
 d_value(Z,Sigma,sim_size = 5)
#To save time, we set the simulation size to be 10, but the default value is much better.
\donttest{
library(MASS)
######################################
#construct a test statistic vector Z
p = 1000
n_col = 4
pi_0 = 0.6
pi_1 = 0.2
pi_2 = 0.2
nu_0 = 0
mu_1 = -1.5
mu_2 = 1.5
tau_sqr_1 = 0.1
tau_sqr_2 = 0.1


A = matrix(rnorm(p*n_col,0,1), nrow = p, ncol = n_col, byrow = TRUE)
Sigma = A \%*\% t(A) +diag(p)
Sigma = cov2cor(Sigma) #covariance matrix




b = rmultinom(p, size = 1, prob = c(pi_0,pi_1,pi_2))
ui = b[1,]*nu_0 + b[2,]*rnorm(p, mean = mu_1,
     sd = sqrt(tau_sqr_1)) + b[3,]*rnorm(p, mean = mu_2,
      sd = sqrt(tau_sqr_2)) # actual situation
Z = mvrnorm(n = 1,ui, Sigma, tol = 1e-6, empirical = FALSE, EISPACK = FALSE)

d_value(Z,Sigma)

}
}
