% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORTH_Ord.R
\name{ORTH.Ord}
\alias{ORTH.Ord}
\title{function: ORTH.Ord}
\usage{
ORTH.Ord(
  formula_mean,
  data_mean,
  cluster,
  formula_por = NULL,
  data_por = NULL,
  MMORTH = FALSE,
  BC = NULL,
  init_beta = NULL,
  init_alpha = NULL,
  miter = 30,
  crit_level = 1e-04
)
}
\arguments{
\item{formula_mean}{the symbolic description of the marginal mean model that contains the ordinal outcome and marginal mean covariates.}

\item{data_mean}{the data set containing the ordinal outcome and marginal mean covariates.}

\item{cluster}{cluster ID (consecutive integers) in data_mean.}

\item{formula_por}{the symbolic description of marginal association model in the form of a one-sided formula, default is NULL. When leaving formula_por as default, independence working correlation will be used.}

\item{data_por}{a data set for marginal association model, default is NULL. When leaving data_por as default, independence working correlation will be used.}

\item{MMORTH}{a logical value to indicate if matrix-adjusted estimating equations will be applied for the association estimation, default is FALSE.}

\item{BC}{an option to apply bias-correction on covariance estimation, default is NULL. Possible values are "BC1", "BC2", or "BC3".}

\item{init_beta}{pre-specified starting values for parameters in the mean model, default is NULL.}

\item{init_alpha}{pre-specified starting values for parameters in the association model, default is NULL.}

\item{miter}{maximum number of iterations for Fisher scoring, default is 30.}

\item{crit_level}{tolerance for convergence, default is 0.0001.}
}
\value{
A list is returned. The first element is a matrix for model parameter estimates; the second element is a variance-covariance matrix for model parameters without bias correction (BC0). Additional variance-covarianc matrices will be added if argument BC is specified.
}
\description{
This function is designed for analyzing correlated ordinal data with ability to correct small-sample bias.
}
\details{
The method is a modified version of alternating logistic regressions with estimation based on orthogonalized residuals (ORTH).
The within-cluster association between ordinal responses is modeled by global pairwise odds ratios (POR).
A small-sample bias correction to POR parameter estimates based on matrix multiplicative adjusted orthogonalized residuals (MMORTH)
for correcting estimating equations, and bias-corrected sandwich estimators with different options for covariance estimation,
i.e. BC1 (Kauermann & Zeger (1986)), BC2 (Mancl & DeRouen (2001)), and BC3 (Fay & Graubard (2001)).
}
\references{
Can Meng, Mary Ryan, Paul Rathouz, Elizabeth Turner, John S Preisser, and Fan Li. 2023. ORTH.Ord: An R package for analyzing correlated ordinal outcomes using alternating logistic regressions with orthogonalized residuals. \emph{Computer Methods and Programs in Biomedicine}, 237, \doi{10.1016/j.cmpb.2023.107567}.
}
