% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimise_OSLintervals.R
\name{optimise_OSLintervals}
\alias{optimise_OSLintervals}
\title{Find adequate integration intervals for CW-OSL decomposition}
\usage{
optimise_OSLintervals(
  components,
  curve = NULL,
  channel.width = NA,
  channel.number = NA,
  t.start = 0,
  t.end = NA,
  background.component = FALSE,
  verbose = TRUE,
  parallel.computing = FALSE
)
}
\arguments{
\item{components}{\link{data.frame} or \link{numeric} vector (\strong{required}):
Table or vector containing the decay constants of the signal components.
A \link{data.frame} must contain a column \verb{$lambda}. Usually the \link{data.frame} is provided
by \link{fit_OSLcurve}.}

\item{curve}{\link{data.frame} or \link{matrix} or \link[Luminescence:RLum.Data.Curve-class]{Luminescence::RLum.Data.Curve} (\emph{optional}):
OSL signal curve which serves as time axis template.
The input curve will be used to define \code{channel.width} and \code{channel.number}}

\item{channel.width}{\link{numeric} (\emph{optional}):
Channel width in seconds. Necessary if \code{curve} is not given.}

\item{channel.number}{\link{numeric} (\emph{optional}):
Number of channels resp. data points. Necessary if \code{curve} is not given.}

\item{t.start}{\link{numeric} (\emph{with default}):
Starting time of the first interval, per default the start of the measurement.}

\item{t.end}{\link{numeric} (\emph{optional}):
End time of the last interval, per default the end of the measurement.}

\item{background.component}{\link{logical} (\emph{with default}):
If \code{TRUE}, an additional interval for a component with a decay rate of zero will be
determined. This enables the calculation of the signal background level during the signal
decomposition with \link{decompose_OSLcurve}.}

\item{verbose}{\link{logical} (\emph{with default}):
Enables console text output.}

\item{parallel.computing}{\link{logical} (\emph{with default}):
Enables the use of multiple CPU cores. This increases the execution speed significantly
but may need administrator rights and/or a firewall exception.
See \link[DEoptim:DEoptim.control]{DEoptim::DEoptim.control} for further information.}
}
\value{
The input table \code{components} \link{data.frame} will be returned with four additional columns:
\verb{$t.start}, \verb{$t.end} defining the time intervals and \verb{$ch.start}, \verb{$ch.end} assigning those intervals to channel indicies.
If a \link{numeric} vector is given as input, a new \link{data.frame} will be returned.
}
\description{
This function defines integration intervals for CW-OSL component separation with \link{decompose_OSLcurve}.
The underlying iterative optimisation process aims for minimum cross-correlation between the signal components.

The precision of the component separation with \link{decompose_OSLcurve} and the impact of
systematic decay rate errors on the component separation depends on the integration interval definition.
This function minimises the influence of an under/over-estimated decay rate to the
signal intensity calculation of other component. This is done by maximizing the denominator
determinant in Cramers rule, see Mittelstraß (2019) for details. For maximisation, the iterative
evolutionary algorithm of Storn and Price (1997) is used, available in \emph{R} through \link[DEoptim:DEoptim]{DEoptim::DEoptim}.

The inclusion of a background component is supported, see \link{decompose_OSLcurve} for details.
}
\section{Last updates}{


2020-08-23, DM: Replaced previous maximum searching algorithm with \link[DEoptim:DEoptim]{DEoptim::DEoptim}
(\strong{update may have changed analysis results})

2020-10-29, DM: Added \code{parallel.computing} argument; enhanced roxygen documentation (\emph{minor update})
}

\examples{

A <- optimise_OSLintervals(c(2, 0.5, 0.02), channel.width = 0.1, channel.number = 200)
print(A, row.names = FALSE)

}
\references{
Mittelstraß, D., 2019. Decomposition of weak optically stimulated luminescence signals and its application in retrospective dosimetry at quartz (Master thesis). TU Dresden, Dresden.

Storn, R., Price, K., 1997. Differential Evolution – A Simple and Efficient Heuristic for global Optimization over Continuous Spaces. Journal of Global Optimization 11, 341–359.
}
\seealso{
\link{decompose_OSLcurve}, \link{RLum.OSL_decomposition}, \link[DEoptim:DEoptim]{DEoptim::DEoptim}, \link{fit_OSLcurve}
}
\author{
Dirk Mittelstraß, \email{dirk.mittelstrass@luminescence.de}

Please cite the package the following way:

Mittelstraß, D., Schmidt, C., Beyer, J., Heitmann, J. and Straessner, A.:
R package OSLdecomposition: Automated identification and separation of quartz CW-OSL signal components, \emph{in preparation}.
}
