% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.qc.heatmap.R
\name{get.qc.heatmap}
\alias{get.qc.heatmap}
\title{Generates the standard heatmap of scores for each sample.}
\usage{
get.qc.heatmap(
  zscores,
  quality.scores,
  yaxis.lab = colnames(zscores),
  xaxis.lab = quality.scores[, "Sample"],
  filename = NULL,
  yaxis.cex = 0.8,
  xaxis.cex = 0,
  xlab.cex = 1,
  xlab.label = "Samples",
  clustering.method = "none",
  colour.scheme = c("red", "white"),
  colour.centering.value = 0,
  colourkey.labels.at = c(-10:0),
  colourkey.cex = 1,
  at = seq(0, -10, -2),
  same.as.matrix = TRUE,
  row.lines = seq(1, ncol(zscores), 1) + 0.5,
  grid.row = TRUE,
  row.colour = "black",
  row.lwd = 1,
  axes.lwd = 1,
  ...
)
}
\arguments{
\item{zscores}{A dataframe of (sign-corrected) z-scores for each sample and test metric, i.e. the output of correct.zscore.signs}

\item{quality.scores}{A dataframe with columns 'Sum' (of scores) and 'Sample', i.e. the output of accumulate.zscores}

\item{yaxis.lab}{A vector of metric labels for the y-axis; defaults to column names of z-scores}

\item{xaxis.lab}{A vector of sample labels for the x-axis; defaults to ordered Sample column elements in quality.scores}

\item{filename}{Filename for tiff output, or if NULL returns the trellis object itself}

\item{yaxis.cex}{Size of y-axis tick labels, defaults to 0.8}

\item{xaxis.cex}{Size of x-axis tick labels, defaults to 0}

\item{xlab.cex}{Size of x-axis label, defaults to 1}

\item{xlab.label}{The label for the x-axis, defaults so 'Sample'}

\item{clustering.method}{Method used to cluster the records -- \dQuote{none} gives unclustered data. Accepts all agglomerative clustering methods available in hclust, plus \dQuote{diana} (which is divisive).}

\item{colour.scheme}{Heatmap colouring. Accepts old-style themes, or a vector of either two or three colours that are gradiated to create the final palette.}

\item{colour.centering.value}{What should be the center of the colour-map}

\item{colourkey.labels.at}{A vector specifying the tick-positions on the colourkey}

\item{colourkey.cex}{Size of colourkey label text}

\item{at}{A vector specifying the breakpoints along the range of x; each interval specified by these breakpoints are assigned to a colour from the palette. Defaults to seq(0, -10, -2), to give a clear discrete display of colours. If x has values outside of the range specified by “at” those values are shown with the colours corresponding to the extreme ends of the colour spectrum and a warning is given.}

\item{same.as.matrix}{Prevents the flipping of the matrix that the function normally does}

\item{row.lines}{Vector specifying location of lines, default is seq(1, ncol(x), 1) + 0.5. Note: Add 0.5 to customized vector}

\item{grid.row}{Allow turning off of the interior grid-lines. Default is TRUE.}

\item{row.colour}{Interior grid-line colour, defaults to \dQuote{black}. Can be a vector}

\item{row.lwd}{Interior grid-line width, defaults to 1. Setting to zero is equivalent to grid.row = FALSE and grid.col = FALSE.  Can be a vector.}

\item{axes.lwd}{Width of heatmap border. Note it also changes the colourkey border and ticks}

\item{...}{The function can also take any parameter that BoutrosLab.plotting.general::create.heatmap takes}
}
\value{
The heatmap or NULL depending if filename is specified
}
\description{
This function takes the the scores for each sample and each metric,
after being sign-corrected, and returns the standard heatmap, if filename
is NULL. If filename is not NULL it saves the heatmap to file and returns NULL.
The function also takes quality.scores to make sure the samples are ordered correctly, as well as the y labels
for the quality metrics.
get.qc.heatmap offers a standard template for generating a QC heatmap, but can also take any parameter
that BoutrosLab.plotting.general::create.barplot takes for customisability.
}
