% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/OmnibusFisher_outer.R
\name{OmnibusFisher}
\alias{OmnibusFisher}
\title{A modified Fisher’s method (Omnibus-Fisher) to combine separate p-values of SNPs, RNA expressions and DNA methylations into an overall gene-level p-value}
\usage{
OmnibusFisher(pheno, full_id, G = NULL, M = NULL, R = NULL,
  exprs_G = NULL, exprs_M = NULL, exprs_R = NULL, type, optimal = FALSE,
  perturb_iteration = NULL, method = "kuonen")
}
\arguments{
\item{pheno}{A matrix of sample ID, trait (i.e., y) and covariates (class: data.frame).}

\item{full_id}{A vector of sample ID. This vector should include all IDs. In other words, samples with all 3 types of omics data, with 2 types and with 1 type should have their IDs in the vector (class: data.frame).}

\item{G}{A matrix of genotypes in a gene. The 1st column is sample ID. Each column is a SNP in the following columns (class: data.frame).}

\item{M}{A matrix of methylated sites in a gene. The 1st column is sample ID. Each column is a methylated site in the following columns (class: data.frame).}

\item{R}{A matrix of RNA expression probes in a gene (for microarray, one gene could have multiple probes mapped; for RNAseq, one gene always has one value). The 1st column is sample ID. For microarray, each column is a probe in the following columns; for RNAseq, the 2nd column is the expression value (only two columns) (class: data.frame).}

\item{exprs_G}{Regression model for SNPs under the null hypothesis (i.e., SNP effect is zero), y = cov1 + cov2 + ... + covp.}

\item{exprs_M}{Regression model for DNA methylation under the null hypothesis (i.e., methylation effect is zero), y = cov1 + cov2 + ... + covp.}

\item{exprs_R}{Regression model for RNA expression under the null hypothesis (i.e., RNA expression effect is zero), y = cov1 + cov2 + ... + covp.}

\item{type}{Either type="binary" or type="continuous" for binary or continuous traits.}

\item{optimal}{Whether use optimal method to automatically search for the disease model (perturbation invovled).}

\item{perturb_iteration}{The number of perturbation iterations when using optimal method. For example, 1,000,000, then the lowest p-value can be obtained for perturbation method is 1/1,000,001.}

\item{method}{Method used to approximately calculate p-values: "kuonen" or "davies". Default "kuonen".}
}
\value{
1. pval_GMR_pert:   the overall gene-level p-value automatically searching for the optimal disease model, when inputting three types of data. \cr
        2. pval_GMR_tri:   the overall gene-level p-value assuming all three types of data in the disease model, when inputting three types of data. \cr
        3. pval_GM_tri/pval_GR_tri/pval_MR_tri:   the overall gene-level p-value automatically searching for the optimal disease model, when inputting two types of data. \cr
        4. pval_GM_tri/pval_GR_tri/pval_MR_tri:   the overall gene-level p-value assuming two types of data in the disease model, when inputting two types of data. \cr
        5. pval_G/pval_M/pval_R:   the gene-level p-value for single type of data. \cr
}
\description{
* Each sample does not have to have all three types of omics data; each gene needs to have all three types of omics data mapped to it. \cr
* For example, 1,000 samples have SNPs mapped to 20,000 genes; 500 samples have methylated sites mapped to 18,000 genes; 300 samples have 16,000 expressed genes. \cr
* Then, all 1,000 samples (500 and 300 samples are included in the total 1,000 samples) contribute to the test. We are interested in the overlapped genes (e.g., 16,000 genes with SNPs, methylated sites and expression genes mapped to them)
}
\examples{
################
### Examples ###
################
data("example_data")
set.seed(123)
exprs_G = exprs_M = exprs_R = "aff ~ age + sex"
### SNPs (G), DNA methylations (M) and RNA expressions (R) ###
results<-list()
for(i in 1:1){ #change to 1:3 for 3 genes
 results[[i]]<-OmnibusFisher(pheno=pheno, full_id=All_header, G=G[[i]], M=M[[i]],
 R=R[[i]], exprs_G=exprs_G, exprs_M=exprs_M, exprs_R=exprs_R, type="binary")
 # G[[1]] includes SNPs in gene1;
 # M[[1]] includes methylated sites in gene1;
 # R[[1]] includes gene expression probes in gene1 (or single gene1 expression value).
}
### SNPs (G) and DNA methylations (M) ###
results<-list()
for(i in 1:1){
 results[[i]]<-OmnibusFisher(pheno=pheno, full_id=All_header, G=G[[i]], M=M[[i]],
 exprs_G=exprs_G, exprs_M=exprs_M, type="binary")
}
### SNPs (G) and RNA expressions (R) ###
# results[[i]]<-OmnibusFisher(pheno=pheno, full_id=All_header, G=G[[i]], R=R[[i]],
# exprs_G=exprs_G, exprs_R=exprs_R, type="binary")
### DNA methylations (M) and RNA expressions (R) ###
# results[[i]]<-OmnibusFisher(pheno=pheno, full_id=All_header, R=R[[i]], M=M[[i]],
# exprs_R=exprs_R, exprs_M=exprs_M, type="binary")
}

