% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{rules_broken}
\alias{rules_broken}
\title{Check which rules were broken}
\usage{
rules_broken(results, show_decision)
}
\arguments{
\item{results}{A data frame with validation results.}

\item{show_decision}{A logical value to indicate if successful decisions should be included in the output.}
}
\value{
A data frame with the filtered results.
}
\description{
Filter the results of validation to show only broken rules, optionally including successful decisions.
}
\examples{
# Sample validation results data frame
sample_results <- data.frame(
  description = c("Rule 1", "Rule 2", "Rule 3"),
  status = c("error", "success", "error"),
  name = c("rule1", "rule2", "rule3"),
  expression = c("col1 > 0", "col2 <= 5", "col3 != 10"),
  stringsAsFactors = FALSE
)

# Show only broken rules
broken_rules <- rules_broken(sample_results, show_decision = FALSE)
}
