% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.r
\name{importExcel}
\alias{importExcel}
\title{Import grid data from an Excel file.}
\usage{
importExcel(file, sheet = 1, format = "wide", rmin = NULL, rmax = NULL)
}
\arguments{
\item{file}{Path(s) to Excel file(s) (suffix \code{.xlsx}).}

\item{sheet}{Names or indexes of sheet with grid data to import.}

\item{format}{Two formats are supported. \code{wide} (default): each column represents one element, each row represent
one constructs. \code{long}: each row contains one rating value for a element-construct combination. See
sections below and examples.}

\item{rmin, rmax}{Min and max of the rating scale (\code{numeric}, default \code{NULL}).}
}
\value{
A \code{repgrid} object (one input file) or a named list with \code{repgrid} objects (several input files). List names are
filename + sheet.
}
\description{
You can define a grid in a Microsoft Excel file (suffix \code{.xlsx}). The file must have one of
two formats (\code{wide} or \code{long}, see format sections below).
}
\section{Format \code{wide}}{


In the \code{wide} format, each element has a separate column, and each row contains the ratzings for one construct.
It is a common way to represent grid data and looks like this:

\tabular{lccccrr}{
\code{1}           \tab \code{element_1} \tab \code{element_2} \tab \code{element_3} \tab \code{element_4}  \tab \code{5}            \tab \code{preferred} \cr
\code{left_pole_1} \tab \code{1}         \tab \code{5}         \tab \code{3}         \tab \code{4}          \tab \code{right_pole_1} \tab \code{left} \cr
\code{left_pole_2} \tab \code{3}         \tab \code{1}         \tab \code{1}         \tab \code{3}          \tab \code{right_pole_2} \tab \code{right} \cr
\code{left_pole_3} \tab \code{4}         \tab \code{2}         \tab \code{5}         \tab \code{1}          \tab \code{right_pole_3} \tab \code{NA} \cr
}

The header row contains the minimum of the rating scale (\code{1}), the names of the elements (\code{element_1} to \code{element_4}),
the maximum of the rating scale (\code{5}), and optionally the column \code{preferred}, indicating the preferred pole.
Each row contains the constructs entries (left pole, ratings, right pole, preferred pole). The preferred pole
must be one of \code{left}, \code{right}, \code{none}, \code{NA} (see \code{\link[=preferredPoles]{preferredPoles()}}).
}

\section{Format \code{long}}{


The \code{long} format has this name because it has few columns and many rows. It is a common format
in data analytics. Here, each row contains a different element-construct combination and the corresponding rating
value. The format looks like this:

\tabular{lllrlrr}{
\code{element}   \tab \code{left_pole}   \tab \code{right_pole}   \tab \code{rating} \tab \code{preferred_pole} \tab \code{rmin} \tab \code{rmax} \cr
\verb{element 1} \tab \verb{left pole 1} \tab \verb{right pole 1} \tab \code{1}      \tab \code{left}           \tab \code{1}    \tab \code{5}   \cr
\code{element_2} \tab \verb{left pole 1} \tab \verb{right pole 1} \tab \code{5}      \tab \code{left}           \tab \code{1}    \tab \code{5}   \cr
\code{element_3} \tab \verb{left pole 1} \tab \verb{right pole 1} \tab \code{4}      \tab \code{left}           \tab \code{1}    \tab \code{5}   \cr
}

The columns \code{element}, \code{left_pole}, \code{right_pole}, and \code{rating} are mandatory, the columns \code{preferred_pole}, \code{rmin},
and \code{rmax} are optional. \code{rmin} and \code{rmax} contain the min and max of the rating scale. Alternatively, you may
pass \code{rmin} and \code{rmax} as arguments in the function call.
}

\examples{
file <- system.file("extdata", "grid_01.xlsx", package = "OpenRepGrid")
rg_1 <- importExcel(file, sheet = "wide")
rg_2 <- importExcel(file, sheet = "long", format = "long")

# Open sample file to inspect it (requires Excel to be installed).
\dontrun{
browseURL(file) # may not work on all systems }

# Import more than one Excel file
files <- system.file("extdata", c("grid_01.xlsx", "grid_02.xlsx"), package = "OpenRepGrid")
rgs <- importExcel(files) # returns a list of grids

# Impoort from several sheets at once (all must have same format)
file <- system.file("extdata", "grid_03.xlsx", package = "OpenRepGrid")
rgs <- importExcel(file, sheet = 1:3) # by index
rgs <- importExcel(file, sheet = c("grid 1", "grid 2", "grid 3")) # or by name
}
\seealso{
Import data
\code{\link{importDataframe}()},
\code{\link{importGridcor}()},
\code{\link{importGridstat}()},
\code{\link{importGridsuite}()},
\code{\link{importScivesco}()},
\code{\link{importTxt}()}
}
\concept{import}
