% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/origami_plot_pairwise.R
\name{origami_plot_pairwise}
\alias{origami_plot_pairwise}
\title{Function to generate pairwise origami plot}
\usage{
origami_plot_pairwise(
  df,
  object1,
  object2,
  min_value = NULL,
  pcol1 = rgb(0.2, 0.5, 0.5, 1),
  pfcol1 = rgb(0.2, 0.5, 0.5, 0.1),
  pcol2 = rgb(0.6, 0.3, 0.3, 1),
  pfcol2 = rgb(0.6, 0.3, 0.3, 0.1),
  axistype = 1,
  seg = 4,
  pty = 16,
  plty = 1:6,
  plwd = 1,
  pdensity = NULL,
  pangle = 45,
  cglty = 1.4,
  cglwd = 0.1,
  cglcol = "#000000",
  axislabcol = "#808080",
  title = "",
  na.itp = TRUE,
  centerzero = TRUE,
  vlabels = NULL,
  vlcex = 1,
  caxislabels = seq(0, 1, by = 0.25),
  calcex = NULL,
  paxislabels = NULL,
  palcex = NULL
)
}
\arguments{
\item{df}{input dataframe in the required format}

\item{object1}{the name of the first row that user wants to plot}

\item{object2}{the name of the second row that user wants to plot}

\item{min_value}{auxiliary point in the graph, default is min(df)/2}

\item{pcol1}{color of the line of the first polygon, default is rgb(0.2,0.5,0.5,1)}

\item{pfcol1}{color to fill the area of the first polygon, default is rgb(0.2,0.5,0.5,0.1).}

\item{pcol2}{color of the line of the second polygon, rgb(0.6,0.3,0.3,1)}

\item{pfcol2}{color to fill the area of the second polygon, default is rgb(0.6,0.3,0.3,0.1).}

\item{axistype}{type of axes. 0:no axis label. 1:center axis label only. 2:around-the-chart label only. 3:both center and around-the-chart labels. Default is 1.}

\item{seg}{number of segments for each axis, default is 4.}

\item{pty}{point symbol, default is 16. 32 means not printing the points.}

\item{plty}{line types for plot data, default is 1:6}

\item{plwd}{line widths for plot data, default is 1}

\item{pdensity}{filling density of polygons, default is NULL}

\item{pangle}{angles of lines used as filling polygons, default is 45}

\item{cglty}{line type for radar grids, default is 1.4}

\item{cglwd}{line width for radar grids, default is 0.1}

\item{cglcol}{line color for radar grids, default is #000000}

\item{axislabcol}{color of axis label and numbers, default is #808080}

\item{title}{title of the chart, default is blank}

\item{na.itp}{logical. If true, items with NA values are interpolated from nearest neighbor items and connect them. If false, items with NA are treated as the origin. Default is TRUE.}

\item{centerzero}{logical. If true, this function draws charts with scaling originated from (0,0). If false, charts originated from (1/segments). Default is TRUE.}

\item{vlabels}{character vector for the names for variables, default is NULL}

\item{vlcex}{font size magnification for vlabels, default is 1}

\item{caxislabels}{center axis labels, default is seq(0,1,by = 0.25)}

\item{calcex}{font size magnification for caxislabels, default is NULL}

\item{paxislabels}{around-the-chart labels, default is NULL}

\item{palcex}{font size magnification for paxislabels, default is NULL}
}
\value{No return value, called for visualization}
\description{
Function to generate pairwise origami plot
}
\details{
This function is an adaptation of the original origami_plot function,
designed to visualize two datasets within a single graph. Pairwise origami plots can serve
as a potent tool for conducting comparisons across various levels, offering unique insights
into the data being analyzed
}
\examples{
data(sucra)
origami_plot_pairwise(sucra, object1="Intravertical PGE2", object2="High-dose oral misoprostol")

}
