% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opm.R
\name{caterplot_longRun}
\alias{caterplot_longRun}
\title{Caterpillar Plots of long run effects based on \code{opm} Model Parameters}
\usage{
caterplot_longRun(
  x,
  parm = NULL,
  main = "Caterpillar plot of long run effects",
  xlab = "Range of parameter samples",
  probs = c(0.025, 0.05, 0.5, 0.95, 0.975),
  labels = colnames(ranges)
)
}
\arguments{
\item{x}{an instance of class \code{opm}}

\item{parm}{a specification of which parameters are to be plotted,
a vector of names are the only legal values. If missing, all parameters are considered.}

\item{main, xlab}{useful defaults for the plot title and X-axis label}

\item{probs}{a vector specifying the quantiles, the defaults is 2.5\%, 5\%, 50\%, 95\%, and 97.5\% quantiles}

\item{labels}{labels for each parameter's interval: see \code{\link[graphics]{axis}}}
}
\value{
A matrix of 2.5\%, 5\%, 50\%, 95\%, and 97.5\% quantiles for
each of the desired parameters, with model parameters arranged in
columns.
}
\description{
Creates side-by-side plots of equal-tailed credible intervals of \code{opm}
the long run effects parameters. The intervals are displayed as horizontal lines,
with 90\% interval using a thicker line width and 95\% interval a
thinner one. The posterior median is indicated with a dot.
}
\examples{
\dontrun{
caterplot_longRun(o, main = NULL)
}

}
