\name{colonization}

\alias{colonization}

\title{Inference of minimum number of colonization events}

\description{
    A inference of the minimum number of colonization events between islands of
    an archipelago considering both haplotype distributions and genealogy.
}

\usage{
colonization(data, network)
}

\arguments{
    \item{data}{
        a data frame containing the matrix of occurrences of haplotypes in the
        islands of an archipelago (applicable to any island-like system). The
        first two columns indicate islands and populations sampled. Successive
        columns indicate haplotype occurrences (one column per haplotype). If
        present, missing haplotypes must also be included (i.e. columns without
        occurrences).
    }
    \item{network}{
        a data frame containing the genealogy of haplotypes. The first column
        indicates the haplotype, the second column indicates its ancestral
        haplotype and the third column indicates the variable position changed
        between an haplotype and its ancestral haplotype. If present, missing
        haplotypes must also be included. The ancestral haplotype must be
        connected to an outgroup named \code{"OUT"}, located in the first row of
        the data frame, and has a variable position not shared with other
        connections.
    }
}

\details{
    Colonization events are inferred following Coello et al. (2022).

    Each haplotype produces a number of colonization events equal to the total
    number of islands in which the haplotype occurs minus one. These are type 1
    colonization events (\code{c1}).

    Additionally, colonization events between an ancestral haplotype and the
    derived haplotypes are also inferred if the ancestral haplotype occurs in
    different islands than the derived haplotypes. These inferred colonization
    events correspond to type 2 (\code{c2}) and type 3 (\code{c3}) colonization
    events.

    A type 2 colonization events is that between a haplotype and its ancestral
    haplotype that can only be assigned to the connection between these two
    haplotypes. These colonization events are noted in the derived haplotype.

    Type 3 colonization events are those (one or more) inferred between an
    ancestral haplotype and its derived haplotypes but that cannot be assigned
    to a specific connection, so colonization events are assigned to the
    ancestral haplotype.
}

\value{
    \code{colonization} returns an object of \code{\link[base]{class}}
    \code{"colonization"}.

    The function \code{print} shows the total of colonization events inferred.
    The function \code{summary} returns a more detailed output showing a
    description of data used and inferred colonization events by haplotype and
    by type.
}

\references{
    Coello, A.J., Fernandez-Mazuecos, M., Heleno, R.H., Vargas, P. (2022).
    PAICE: A new R package to estimate the number of inter-island colonizations
    considering haplotype data and sample size. \emph{Journal of Biogeography},
    49(4), 577-589.DOI:
    \href{https://onlinelibrary.wiley.com/doi/10.1111/jbi.14341}{10.1111/jbi.14341}
}

\note{
    \code{colonization} only considers the complete sampling. To correct the
    inference by field and genetic sampling use \code{\link{rarecol}}.
}

\seealso{
    \code{\link{rarecol}} to build a rarefaction curve of colonization events.
    \code{\link{maxCol}} to calculate the asymptotic estimator for the number of
    colonization events from data generated by \code{\link{rarecol}}.
}

\examples{
data(CmonsData)
data(CmonsNetwork)
col <- colonization(data = CmonsData, network = CmonsNetwork)
col # Total of colonization events inferred
summary(col) # Detailed description of inferred colonization events
}

\keyword{ univar }
