\name{rarecol}

\alias{rarecol}


\title{Rarefaction curve of colonization events}

\description{
    A creation of rarefaction curves considering both genetic and field data.
    First, the function samples variable positions and then samples populations
    for each variable position. Second, it samples populations and then samples
    variable positions for each population.
}

\usage{
rarecol(data, network, replicates_field = 10,
        replicates_genetic = 10, mode = c(1, 2), monitor = TRUE,
        file = NULL)
}

\arguments{
    \item{data}{
        a data frame containing the occurrence matrix of haplotypes in the
        islands of an archipelago (applicable to any island-like system). The
        first two columns indicate islands and populations sampled. Successive
        columns indicate haplotype occurrences (one column per haplotype). If
        present, missing haplotypes must also be included (i.e. columns without
        occurrences).
    }
    \item{network}{
        a data frame containing the genealogy of haplotypes. The first column
        indicates the haplotype, the second column indicates its ancestral
        haplotype and the third column indicates the variable position changed
        between an haplotype and its ancestral haplotype. If present, missing
        haplotypes must also be included. The ancestral haplotype must be
        connected to an outgroup named \code{"OUT"}, located in the first row of
        the data frame, and has a variable position not shared with other
        connections.
    }
    \item{replicates_field}{
        numeric. Number of replicates for field resampling. Each replicate adds
        populations from one to the total number of populations in the dataset
        and infers the corresponding number of colonization events.
    }
    \item{replicates_genetic}{
        numeric. Number of replicates for genetic resampling. Each replicate
        adds variable positions from none (chorology) to the total number of
        variable positions in the dataset and infers the corresponding number of
        colonization events.
    }
    \item{monitor}{
        logical. If \code{TRUE} it shows progress in the console.
    }
    \item{mode}{
        numeric vector. Indicates which estimations must be conducted. 1 for
        genetic estimation and 2 for field estimation. By default the function
        conducts both processes.
    }
    \item{file}{
        character string determining the name of the file to save rarefaction
        curves built by this function. Two files are created, one for genetic
        estimation and one for field estimation. If a file name is indicated,
        the function does not return any result, all the results are saved in
        the indicated files. If set to \code{NULL}, the data are showed as
        output.
    }
}

\value{
    \code{rarecol} returns an object of \code{\link[base]{class}}
    \code{"rarecol"}. The return is a list containing information about the two
    rarefaction curves generated.
}

\references{
    Coello, A.J., Fernandez-Mazuecos, M., Heleno, R.H., Vargas, P. (2022).
    PAICE: A new R package to estimate the number of inter-island colonizations
    considering haplotype data and sample size. \emph{Journal of Biogeography},
    49(4), 577-589.DOI:
    \href{https://onlinelibrary.wiley.com/doi/10.1111/jbi.14341}{10.1111/jbi.14341}
}

\seealso{
    To describe the number of colonization events observed in the most complete
    case, use the function \code{\link{colonization}}. \code{\link{maxCol}},
    which estimates the number of colonization events of data generated by this
    funtion. \code{\link{plot.rarecol}} to plot the result of this function.
    \code{\link{read.rarecol}} to import files generated from this function.
}

\examples{\donttest{
data(CmonsData)
data(CmonsNetwork)
# Build rarefaction curves with 5 field and genetic replicates
## Note: more replicates are needed to build accurate curves
## Note: 5 replicates are relatively fast and adequate to
##       explore the data
rcol <- rarecol(data = CmonsData, network = CmonsNetwork,
                replicates_field = 5, replicates_genetic = 5,
                monitor = TRUE, mode = c(1, 2))
old.par <- par(no.readonly = TRUE) # To restore previous options
par(mfrow = c(1, 2))
plot(rcol) # Plotting results
par(old.par)
}}

\keyword{ datagen }
