% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addWaveHeight.R
\name{addWaveHeight}
\alias{addWaveHeight}
\title{Add Wave Height Data to an AcousticStudy}
\usage{
addWaveHeight(x, height, thresh = 3600)
}
\arguments{
\item{x}{an \linkS4class{AcousticStudy} to add height data to}

\item{height}{either a single numeric value, or a dataframe
with column \code{UTC} and either column \code{waveHeight} 
specifying height (m) at that time, or \code{beaufort} specifying
the beaufort sea state at that time}

\item{thresh}{maximum time apart in seconds for matching height to
data, if the closest value is more than \code{thresh} apart then the
height value will be set to \code{NA}}
}
\value{
the same data as \code{x}, with wave height data added. All AcousticEvents will
  have height data added to all detector dataframes as column \code{waveHeight}
}
\description{
Add wave height to an AcousticStudy or AcousticEvent
}
\details{
height values will be matched to the data
  by using data.table's rolling join with \code{roll='nearest'}. After the
  join is done, the time difference between the matched rows is checked
  and any that are greater than the set threshold are set to NA. This is
  done to prevent accidentally matching weird things if an incomplete set
  of height data is provided.
}
\examples{

data(exStudy)
# need to update database file to local directory
exStudy <- addWaveHeight(exStudy, height=.5)
getClickData(exStudy[1])

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
