% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chromaPlot.R
\name{chromaPlot}
\alias{chromaPlot}
\title{Chroma plot}
\usage{
chromaPlot(x, varLabels = NULL, cvCO = 1, splitLabels = NULL,
  varAnnotation = "cum", useComps = NULL)
}
\arguments{
\item{x}{Either a \code{PCADSC} object or a \code{chromaInfo} object, as produced
by \code{\link{PCADSC}} and \code{\link{doChroma}}.}

\item{varLabels}{A vector of character string labels for the variables used in
\code{pcadscObj}. If non-\code{NULL}, these labels appear in the plot instead of the
variable names.}

\item{cvCO}{A numeric in the interval \eqn{[0,1]} where the default, \code{1}, corresponds
to no cut-off value. If a value smaller than 1, only the first \eqn{n} components are plotted,
where \eqn{n} is the the lowest possible number, such that the cumulative variance contribution
of the first \eqn{n} components exceeds \code{cvCO} for both datasets. Note that setting
\code{covCO} will overrule the argument \code{useComps}.}

\item{splitLabels}{Labels for the two categories of the splitting variable used
to create the \code{PCADSC} object, \code{x}, given as a named list (see examples).
These labels will appear in the headers of the two PCADSC plots.
If \code{NULL} (the default), the original levels of the splitting variable
are used.}

\item{varAnnotation}{If \code{"cum"} (the default), cummulated explained variance
percentages are annotated to the right of the bars for each component. If \code{"raw"},
the non-cummulated percentages of explained variance are added instead. If \code{NULL},
no annotation is added. Note that \code{"cum"} is only allowed if \code{useComps} is
non-\code{NULL}.}

\item{useComps}{A vector of integers with the indexes of the principal component
that should be included in the plot.}
}
\description{
Produce a chroma plot from a full or partial \code{PCADSC} object, as obtained
from a call to \code{\link{PCADSC}}. In either case, this \code{PCADSC} object must have a
non-\code{NULL} \code{chromaInfo} slot (see examples). The chroma plot compares the loading
patterns from PCA conducted on two datasets consisting of different observations of the
same variables.
}
\details{
The plot consists of one display for each of the two datasets. The two displays both
consist of a number of vertical bars. Each vertical bar represents a principal component and the
 width of each colored section (chroma) within the bar corresponds to the normalized PCA loading
 vector of that component. The bars can be annotated with the (cumulative) variance contributions
 of the components (see \code{varAnnotation}).
}
\examples{
#load iris data
data(iris)

#Define grouping variable, grouping the observations by whether their species is
#Setosa or not
iris$group <- "setosa"
iris$group[iris$Species != "setosa"] <- "non-setosa"
iris$Species <- NULL

\dontrun{
#make a PCADSC object, splitting the data by "group"
irisPCADSC <- PCADSC(iris, "group")

#make a partial PCADSC object from iris and fill out chromaInfo in the next call
irisPCADSC2 <- PCADSC(iris, "group", doChroma = FALSE)
irisPCADSC2 <- doChroma(irisPCADSC2)

#make a chroma plot
chromaPlot(irisPCADSC)
chromaPlot(irisPCADSC)

#Change the labels of the splitting variable
chromaPlot(irisPCADSC, splitLabels = list("non-setosa" = "Not Setosa",
    "setosa" = "Setosa"))

#Only plot components 1 and 4 and remove annotated variances
chromaPlot(irisPCADSC, useComps = c(1,4), varAnnotation = "no")

#Only plot the first components responsible for explaining 80 percent variance
chromaPlot(irisPCADSC, cvCO = 0.8)

#Change variable labels
chromaPlot(irisPCADSC, varLabels = c("Sepal length", "Sepal width", "Petal length",
   "Petal width"))
}

#Only do chroma information in order to get a faster runtime:
irisPCADSC_fast <- PCADSC(iris, "group", doCE = FALSE,
  doAngle = FALSE)
chromaPlot(irisPCADSC_fast)

}
\seealso{
\code{\link{PCADSC}}, \code{\link{doChroma}}
}

