% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doAngle.R
\name{doAngle}
\alias{doAngle}
\title{Compute angle information}
\usage{
doAngle(x)
}
\arguments{
\item{x}{Either a \code{PCADSC} or a \code{pcaRes} object.}
}
\description{
Computes the information that is needed in order to make an \code{\link{anglePlot}}
from a \code{PCADSC} or \code{pcaRes} object. Typically, this function is called on a partial
\code{PCADSC} object in order to add \code{angleInfo} (see examples).
}
\examples{
#load iris data
data(iris)

#Define grouping variable, grouping the observations by whether their species is
#Setosa or not
iris$group <- "setosa"
iris$group[iris$Species != "setosa"] <- "non-setosa"
iris$Species <- NULL

\dontrun{
#make a partial PCADSC object, splitting the data by "group"
irisPCADSC <- PCADSC(iris, "group", doAngle = FALSE)

#No angleInfo available
irisPCADSC$angleInfo

#Add and show angleInfo
irisPCADSC <- doAngle(irisPCADSC)
irisPCADSC$angleInfo
}

#Make a partial PCADSC object and only add angle information for a
#faster runtime
irisPCADSC_fast <- PCADSC(iris, "group", doAngle = FALSE,
  doChroma = FALSE, doCE = FALSE)
irisPCADSC_fast <- doAngle(irisPCADSC_fast)
irisPCADSC_fast$angleInfo

}
\seealso{
\code{\link{anglePlot}}, \code{\link{PCADSC}}
}

