% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.PCLasso.R
\name{cv.PCLasso}
\alias{cv.PCLasso}
\title{Cross-validation for \code{PCLasso}}
\usage{
cv.PCLasso(
  x,
  y,
  group,
  penalty = c("grLasso", "grMCP", "grSCAD"),
  nfolds = 5,
  standardize = TRUE,
  ...
)
}
\arguments{
\item{x}{A n x p design matrix of gene/protein expression measurements with n
samples and p genes/proteins, as in \code{PCLasso}.}

\item{y}{The time-to-event outcome, as a two-column matrix or \code{Surv}
object, as in \code{PCLasso}. The first column should be time on study
(follow up time); the second column should be a binary variable with 1
indicating that the event has occurred and 0 indicating (right) censoring.}

\item{group}{A list of groups as in \code{PCLasso}. The feature
(gene/protein) names in \code{group} should be consistent with the feature
(gene/protein) names in \code{x}.}

\item{penalty}{The penalty to be applied to the model. For group selection,
one of grLasso, grMCP, or grSCAD. For bi-level selection, one of gel or
cMCP. See \code{grpsurv} in the R package \code{grpreg} for details.}

\item{nfolds}{The number of cross-validation folds. Default is 5.}

\item{standardize}{Logical flag for \code{x} standardization, prior to
fitting the model. Default is \code{TRUE}.}

\item{...}{Arguments to be passed to \code{cv.grpsurv} in the R package
\code{grpreg}.}
}
\value{
An object with S3 class "cv.PCLasso" containing: \item{cv.fit}{ An
object of class "cv.grpsurv".} \item{complexes.dt}{ Complexes with
features (genes/proteins) not included in \code{x} being filtered out. }
}
\description{
Perform k-fold cross validations for the PCLasso model with grouped
covariates over a grid of values for the regularization parameter
\code{lambda}.
}
\details{
The function calls \code{PCLasso} \code{nfolds} times, each time
leaving out 1/\code{nfolds} of the data. The cross-validation error is based
on the deviance. The numbers for censored samples are balanced across the
folds. \code{cv.PCLasso} uses the approach of calculating the full Cox
partial likelihood using the cross-validated set of linear predictors. See
\code{cv.grpsurv} in the R package \code{grpreg} for details.
}
\examples{
# load data
data(survivalData)
data(PCGroups)

x = survivalData$Exp
y = survivalData$survData

PC.Human <- getPCGroups(Groups = PCGroups, Organism = "Human",
Type = "EntrezID")

# fit model
cv.fit1 <- cv.PCLasso(x, y, group = PC.Human, penalty = "grLasso",
nfolds = 10)
}
\references{
PCLasso: a protein complex-based, group lasso-Cox model for accurate
prognosis and risk protein complex discovery. Brief Bioinform, 2021.

Park, H., Niida, A., Miyano, S. and Imoto, S. (2015) Sparse overlapping group
lasso for integrative multi-omics analysis. Journal of computational biology:
a journal of computational molecular cell biology, 22, 73-84.
}
\seealso{
\code{\link{predict.cv.PCLasso}}
}
\author{
Wei Liu
}
