% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments.r
\name{moment2cumulant}
\alias{moment2cumulant}
\title{Convert moments to raw cumulants.}
\usage{
moment2cumulant(moms)
}
\arguments{
\item{moms}{a vector of the moments. The first element is the first moment
(the mean).  
If centered moments are given, the first moment must be zero. 
If raw moments are given, the first moment must be the mean.}
}
\value{
a vector of the cumulants. 
The first element of the input shall be the same as the first element of the output.
}
\description{
Conversion of a vector of moments to raw cumulants.
}
\details{
The 'raw' cumulants \eqn{\kappa_i}{kappa_i} are connected
to the 'raw' (uncentered) moments, \eqn{\mu_i'}{mu'_i} via
the equation
\deqn{\kappa_n = \mu_n' - \sum_{m=1}^{n-1} {n-1 \choose m-1} \kappa_m \mu_{n-m}'}

Note that this formula also works for central moments, assuming
the distribution has been normalized to zero mean.
}
\note{
The presence of a \code{NA} or infinite value in the input
will propagate to the output.
}
\examples{
# normal distribution, mean 0, variance 1
n.cum <- moment2cumulant(c(0,1,0,3,0,15))
# normal distribution, mean 1, variance 1
n.cum <- moment2cumulant(c(1,2,4,10,26))
# exponential distribution
lambda <- 0.7
n <- 1:6
e.cum <- moment2cumulant(factorial(n) / (lambda^n))
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\seealso{
\code{\link{cumulant2moment}}
}
\keyword{distribution}

