% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/30_CONFUSION_MATRIX.R
\name{confusion.matrix}
\alias{confusion.matrix}
\title{Confusion matrix}
\usage{
confusion.matrix(predictions, observed, cutoff)
}
\arguments{
\item{predictions}{Model predictions.}

\item{observed}{Observed values of target variable.}

\item{cutoff}{Cutoff value. Single value numeric vector between 0 and 1.}
}
\value{
The command \code{confusion.matrix} returns list of two objects. The first object is confusion matrix table,
while the second one is data frame with accompanied performance metrics.
}
\description{
\code{confusion.matrix} returns confusion matrix along with accompanied performance metrics.
}
\examples{
suppressMessages(library(PDtoolkit))
data(loans)
#identify numeric risk factors
num.rf <- sapply(loans, is.numeric)
num.rf <- names(num.rf)[!names(num.rf)\%in\%"Creditability" & num.rf]
#discretized numeric risk factors using mdt.bin from monobin package
loans[, num.rf] <- sapply(num.rf, function(x) 
			  mdt.bin(x = loans[, x], y = loans[, "Creditability"])[[2]])
str(loans)
res <- stepFWD(start.model = Creditability ~ 1, 
   p.value = 0.05, 
   coding = "WoE",
   db = loans)
names(res)
summary(res$model)$coefficients
loans$model.pred <- predict(res$model, type = "response")
#confusion matrix
confusion.matrix(predictions = predict(res$model, type = "response"), 
	     observed = loans$"Creditability",
	     cutoff = 0.5)
}
