% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfw_region.R
\name{pfw_region}
\alias{pfw_region}
\title{Filter Project FeederWatch Data by Region}
\usage{
pfw_region(data, regions)
}
\arguments{
\item{data}{A Project FeederWatch dataset.}

\item{regions}{A character vector of regions (e.g., "Washington", "United States").}
}
\value{
A filtered dataset containing only the selected regions.
}
\description{
This function filters Project FeederWatch data to
include only specified states, provinces, or countries.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Download/load example dataset
data <- pfw_example

# Filter for data only from Washington using the state name
data_WA <- pfw_region(data, "Washington")

# Filter for data only from Washington using the state code
data_WA <- pfw_region(data, "US-WA")

# Filter for data from Washington, Oregon,
# and California using the state name
data_westcoastbestcoast <- pfw_region(data, c("Washington", "Oregon", "California"))
\dontshow{\}) # examplesIf}
}
