% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Funnels.R
\name{calculate_funnel_points}
\alias{calculate_funnel_points}
\title{For rate-based funnels: Derive rate and annual population values for charting
based. Process removes rates where the rate type is dsr and the number of
observed events are below 10.}
\usage{
calculate_funnel_points(
  data,
  numerator,
  denominator,
  rate,
  rate_type = NULL,
  years_of_data = NULL,
  multiplier = NULL
)
}
\arguments{
\item{data}{a data.frame containing the data to calculate control limits for;
unquoted string; no default}

\item{numerator}{field name from data containing the observed numbers of
cases in the sample meeting the required condition (the numerator or
observed counts for the control limits); unquoted string; no default}

\item{denominator}{field name from data containing the population(s) in the
sample (the denominator or expected counts for the control limits);
unquoted string; no default}

\item{rate}{field name from data containing the rate data when creating
funnels for a Crude or Directly Standardised Rate; unquoted string; no
default}

\item{rate_type}{if statistic is "rate", specify either "dsr" or "crude";
string; no default}

\item{years_of_data}{number of years the data represents; this is required
for statistic = "rate"; numeric; no default}

\item{multiplier}{the multiplier used to express the final values (eg 100 =
percentage); numeric; no default}
}
\value{
returns the same table as provided with two additional fields. First
will have the same name as the rate field, with the suffix "_chart", the
second will be called denominator_derived
}
\description{
For rate-based funnels: Derive rate and annual population values for charting
based. Process removes rates where the rate type is dsr and the number of
observed events are below 10.
}
\seealso{
Other PHEindicatormethods package functions: 
\code{\link{assign_funnel_significance}()},
\code{\link{calculate_ISRate}()},
\code{\link{calculate_ISRatio}()},
\code{\link{calculate_dsr}()},
\code{\link{calculate_funnel_limits}()},
\code{\link{phe_dsr}()},
\code{\link{phe_life_expectancy}()},
\code{\link{phe_mean}()},
\code{\link{phe_proportion}()},
\code{\link{phe_quantile}()},
\code{\link{phe_rate}()},
\code{\link{phe_sii}()}
}
\author{
Sebastian Fox, \email{sebastian.fox@phe.gov.uk}
}
\concept{PHEindicatormethods package functions}
