% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThreeComp_Volume_Clearance.R
\name{ThreeComp_Volume_Clearance}
\alias{ThreeComp_Volume_Clearance}
\title{Convert pharmacokinetic parameters for three compartment model}
\usage{
ThreeComp_Volume_Clearance(V1,V2,V3,Cl1,Cl2,Cl3,
 V1.sd=NA,V2.sd=NA,V3.sd=NA, Cl1.sd=NA,Cl2.sd=NA,Cl3.sd=NA,
 covar=c(V1V2=NA,V1V3=NA,V1Cl1=NA,
   V1Cl2=NA,V1Cl3=NA,V2V3=NA,V2Cl1=NA,V2Cl2=NA,V2Cl3=NA,
   V3Cl1=NA,V3Cl2=NA,V3Cl3=NA,Cl1Cl2=NA,Cl1Cl3=NA,Cl2Cl3=NA),...)
}
\arguments{
\item{V1}{The volume of distribution of compartment 1}

\item{V2}{The volume of distribution of compartment 2}

\item{V3}{The volume of distribution of compartment 3}

\item{Cl1}{Clearance from compartment 1}

\item{Cl2}{Clearance from compartment 2}

\item{Cl3}{Clearance from compartment 3}

\item{V1.sd}{standard error of V1}

\item{V2.sd}{standard error of V2}

\item{V3.sd}{standard error of V3}

\item{Cl1.sd}{standard error of Cl1}

\item{Cl2.sd}{standard error of Cl2}

\item{Cl3.sd}{standard error of Cl3}

\item{covar}{covariances among parameters}

\item{...}{arguments to be passed to methods}
}
\description{
Calculate pharmacokinetic parameters with volume of distributions
(V1, V2 and V3) and  clearances (Cl1, Cl2, and Cl3)
}
\examples{
ThreeComp_Volume_Clearance(V1=10,V2=100,V3=1000,Cl1=3,Cl2=2,Cl3=1,
  V1.sd=0.01,V2.sd=0.1,V3.sd=1,Cl1.sd=0.01,Cl2.sd=0.01,Cl3.sd=0.01)

}
\references{
\url{http://www.nonmemcourse.com/convert.xls}
}
