% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiLayerNet_functions.R
\name{plexi_distance_test_isn}
\alias{plexi_distance_test_isn}
\title{Test the embedding distances of local neighbors change between the two conditions for ISNs.}
\usage{
plexi_distance_test_isn(
  distance,
  y,
  stat.test = "wilcox.test",
  p.adjust.method = "none"
)
}
\arguments{
\item{distance}{a distance list obtained by the \code{plexi_node_distance()} function.}

\item{y}{vector with the length equal to the number of individuals.}

\item{stat.test}{statistical test used to detect the nodes \code{c("t.test","wilcox.test")} (default: wilcox.test)}

\item{p.adjust.method}{method for adjusting p-value (including methods on \code{p.adjust.methods}).
If set to "none" (default), no adjustment will be performed.}
}
\value{
The adjusted pvalues for each node.
}
\description{
Test the embedding distances of local neighbors change between the two conditions for ISNs.
}
\details{
The adjusted p-values for each node is calculated based on their distance variation between
the two conditions.
}
\examples{
ISN1 = network_gen(n.nodes = 50, n.var.nodes = 5, n.var.nei = 40, noise.sd = .01)
ISN2 = network_gen(n.nodes = 50, n.var.nodes = 5, n.var.nei = 40, noise.sd = .01)
graph_data = cbind(ISN1[["data_graph"]], ISN1[["data_graph"]][,3:4])
embeddingSpaceList = plexi_embedding(graph.data=graph_data, outcome=c(1,2,1,2),
indv.index=c(1,1,2,2), train.rep=2, random.walk=FALSE)
Dist = plexi_node_distance(embeddingSpaceList)
Result = plexi_distance_test_isn(Dist, y = c(1,2))

}
