% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnds_design.R
\name{pnds_design}
\alias{pnds_design}
\title{Create PNDS survey object with its sample design}
\usage{
pnds_design(data_pnds)
}
\arguments{
\item{data_pnds}{A tibble of PNDS microdata read with \code{read_pnds} function.}
}
\value{
An object of class \code{survey.design} or \code{svyrep.design} with the data from PNDS and its sample design.
}
\description{
This function creates PNDS survey object with its sample design for analysis using \code{survey} package functions.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/sociais/saude/9160-pesquisa-nacional-de-demografia-e-saude.html?=&t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
# Using data read from disk
input_path <- pnds_example(path="input_example.txt")
data_path <- pnds_example(path="exampledata.txt")
dictionary.path <- pnds_example(path="dictionaryexample.xls")
deflator.path <- pnds_example(path="deflatorexample.xls")
pnds.df <- read_pnds(microdata=data_path, input_txt=input_path, vars=c("J007","J009"))
pnds.df <- pnds.df[(pnds.df$M001 == "1" & !is.na(pnds.df$M001)),]
pnds.df <- pnds.df[,!(names(pnds.df) \%in\% c("V0029", "V00291", "V00292", "V00293"))]
pnds.df <- pnds_labeller(data_pnds=pnds.df, dictionary.file=dictionary.path)
pnds.df <- pnds_deflator(data_pnds=pnds.df, deflator.file=deflator.path)
\donttest{
pnds.svy <- pnds_design(data_pnds=pnds.df)
# Calculating proportion of people diagnosed with chronic diseases
if (!is.null(pnds.svy)) survey::svymean(x=~J007, design=pnds.svy, na.rm=TRUE)}
\donttest{
# Downloading data
pnds.df2 <- get_pnds(year=2023, section="Female", vars=c("J007","J009"),
                       labels=TRUE, deflator=TRUE, design=FALSE,
                       reload=TRUE, curlopts=list(), savedir=tempdir())
pnds.svy2 <- pnds_design(data_pnds=pnds.df2)
# Calculating proportion of people diagnosed with chronic diseases
if (!is.null(pnds.svy2)) survey::svymean(x=~J007, design=pnds.svy2, na.rm=TRUE)}
}
\seealso{
\link[PNDSIBGE]{get_pnds} for downloading, labeling, deflating and creating survey design object for PNDS microdata.\cr \link[PNDSIBGE]{read_pnds} for reading PNDS microdata.\cr \link[PNDSIBGE]{pnds_labeller} for labeling categorical variables from PNDS microdata.\cr \link[PNDSIBGE]{pnds_deflator} for adding deflator variables to PNDS microdata.\cr \link[PNDSIBGE]{pnds_example} for getting the path of the PNDS toy example files.
}
