% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPOD.R
\name{plotPOD}
\alias{plotPOD}
\title{Generate Plot to Analyze Single Lab PCR Outcomes}
\usage{
plotPOD(obj, model = c("auto", "simple", "full"), qLOD = 95,
  show.ci = TRUE, show.warnings = FALSE, wmark = TRUE, unit = "",
  xlim = NULL, .title = list(main = "", xlab = "Number of DNA copies",
  ylab = "POD and ROD"))
}
\arguments{
\item{obj}{A list returned by \code{\link{analyzeSingleLab}}.}

\item{model}{Simple or full model}

\item{qLOD}{The quantile(s) for LOD to be shown in the plot. Multiplied by \eqn{100} if less than one.}

\item{show.ci}{Show the confidence interval of the LOD in the plot.}

\item{show.warnings}{Show the warning regarding significant deviation from \eqn{1} in the plot.}

\item{wmark}{Logical. Show a watermark at the upper right corner of the plot.}

\item{unit}{A string indicating the unit of the data.}

\item{xlim}{A numeric vector indicating the limits of the x-axis.}

\item{.title}{A list with same arguments as function \code{\link{title}}. Customization of the figure.}
}
\value{
The passed list 'obj' is returned invisibly.
}
\description{
Show POD curve and LOD value to validate qualitative PCR methods of a single laboratory.
}
\details{
The graph generated by this function gives the laboratory-specific rates of detection (RODs) as blue diamonds. The blue curve denotes the mean POD curve along with the corresponding \eqn{95 \%} confidence range highlighted as the grey band. The POD curve under ideal conditions is displayed as the black dashed curve.

If model is set to "auto", a plausiblity test is applied to determine if the POD curve bases on the simplified or on full parameter estimation. If the corrective parameter determined from the full model significantly differs from \eqn{1}, a message is shown in the plot. Testing for significant deviation is currently done by checking the condition \eqn{1-b>0.2}. The threshould \eqn{0.2} has been determined empirically to agree with the original webtool and might be changed in future versions of the package.

Three cases can be distinguished. First, the value for the slope parameter b is significantly less than \eqn{1}. This means the average amplification probability is higher at higher dilution levels than at lower dilution levels. Such a situation can be related to: inhibitory matrix effects, a large variability in the amplification process from the one test to another under repeatability conditions, or accidental problems causing false positives if the number of copies of the target DNA sequence is less than \eqn{1}. Second, the calculated POD curve indicates sensitivity better than achievable according to the theoretical POD curve. Third, the number of positive test results is significantly higher than expected at nominal copies of nominal DNA concentrations in \eqn{[0.5,1.5]}. In this case check the correctness of the serial dilution.

Another warning appears if the LOD of interest exceeds the highest number of considered nominal copies.

The unit is add to the LOD value, in front of the confidence intervall.
}
\examples{
x <- cbind(
 X=c(0.1,1,2,5,10,20),
 S=c( 0,5,6,6,6,6 ),
 N=c( 6,6,6,6,6,6 )
)
obj <- analyzeSingleLab(x=x)
plotPOD(obj)
}
