% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balances.R
\name{node_taxa}
\alias{node_taxa}
\title{Determine taxa labels of tips on each side of a node\cr}
\usage{
node_taxa(
  in_tree,
  taxon_labels,
  node_label = NULL,
  node_index = NULL,
  threshold = 0.75,
  combine_labels = TRUE
)
}
\arguments{
\item{in_tree}{Phylo object}

\item{taxon_labels}{Dataframe of taxa labels for tips in tree.
All tips underlying the specified node must be present, although typically all tips in the tree would be present.
Row names must be the tip labels. The column names correspond to each taxonomic level, such as Kingdom, Phylum, etc.
The actual column names do not matter: it is just important that the order of the taxonomic levels goes from the highest taxonomic level present (e.g., Kingdom), to the lowest taxonomic level present (e.g., Species).}

\item{node_label}{Optional label of node for which the representative taxon label will be determined. Either this option or the node_index option must be specified, but not both.}

\item{node_index}{As above for the node_label option, but to specify a node by index rather than by label.}

\item{threshold}{Float > 0.5 and <= 1.0 specifying the proportion of tips that must share a taxon label for it to be considered representative.}

\item{combine_labels}{Boolean flag for whether taxon labels should be combined, so that all higher taxonomic labels are included.
Specifically, when TRUE, all higher labels are concatenated and delimited by "; ".
E.g., rather than just the genus "Odoribacter" the label would be "Bacteria; Bacteroidetes; Bacteroidia; Bacteroidales; Porphyromonadaceae; Odoribacter",
given that those were the labels of the higher taxonomic levels of that genus.}
}
\value{
Character vector of size two with the representative taxon for tips on each side of the specified node.
}
\description{
Takes in a tree, a table of taxa labels per tip, and either a node label or index.\cr
}
\details{
\strong{The format of the taxa label table is very important to note: it must have the tips as the rownames and taxonomic levels (ranging from highest to lowest) as the column names}.

For each side of the specified node separately, this function returns the lowest possible taxon label shared by at
least the specified proportion of tips (set by the "threshold" variable). Will return "Unclear" if there is no applicable taxon.\cr

To clarify, the taxon that meets the threshold at the lowest possible taxonomic level will be used as the representative label.
For example, if all the tips on one side of the node are members of the Pseudomonas genus, but only 60\% are members of the Pseudomonas aeruginosa species specifically,
then Pseudomonas will be used as the representative label (based on a threshold of 0.75 or higher and assuming that species are the last column in the table).
}
