% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\docType{data}
\name{PPMiss.copulas}
\alias{PPMiss.copulas}
\alias{frank}
\alias{dCtheta_frank}
\alias{amh}
\alias{dCtheta_amh}
\alias{fgm}
\alias{dCtheta_fgm}
\alias{gauss}
\alias{dCtheta_gauss}
\title{Copula functions and the corresponding derivative limit.}
\format{
An object of class \code{frankCopula} of length 1.

An object of class \code{amhCopula} of length 1.

An object of class \code{fgmCopula} of length 1.

An object of class \code{normalCopula} of length 1.
}
\usage{
frank

dCtheta_frank(u, v)

amh

dCtheta_amh(u, v)

fgm

dCtheta_fgm(u, v)

gauss

dCtheta_gauss(u, v)
}
\arguments{
\item{u}{a real number between 0 and 1.}

\item{v}{a real number between 0 and 1.}
}
\value{
Archimedean copula objects of class \sQuote{frankCopula}, \sQuote{amhCopula} or a
Farlie-Gumbel-Morgenstern copula object of class \sQuote{fgmCopula} or an elliptical
copula object of class \sQuote{normalCopula}. For details, see
\code{\link[copula]{archmCopula}}, \code{\link[copula]{fgmCopula}} and
\code{\link[copula]{ellipCopula}}.

The derivative functions return the limit, as \eqn{\theta \to 0}, of the
derivative with respect to \eqn{\theta}, corresponding to the copula functions.
}
\description{
Implemented copulas and the corresponding derivative limit,
as \eqn{\theta \to a}, where \eqn{a} is such that \eqn{C_a(u,v)=uv}.
An estimate for \eqn{\theta} is obtained based on the copula function used.
and the derivatives are used to obtain an estimate for \eqn{K_1}.
The functions \sQuote{frank}, \sQuote{amh}, \sQuote{fgm} and \sQuote{gauss}
are shortcuts for  \code{\link[copula:frankCopula]{copula::frankCopula()}},
\code{\link[copula:amhCopula]{copula::amhCopula()}}, \code{\link[copula:fgmCopula]{copula::fgmCopula()}} and
\code{\link[copula:normalCopula]{copula::normalCopula()}} from package \sQuote{copula},
respectively.
}
\details{
The constant \eqn{K_1} is given by

\deqn{K_1 = \int_0^1\int_0^1\frac{1}{l_0(u)l_n(v)}\lim_{\theta\rightarrow a}\frac{\partial C_{\theta}(u,v)}{\partial\theta}\,dudv, }

where \eqn{I=[0,1]}, \eqn{l_m(x):= F_m'\big(F_m^{(-1)}(x)\big)} and
\eqn{\{F_n\}_{n \geq 0}} is a sequence of absolutely continuous distribution
functions
}
\keyword{datasets}
