% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.prosper.R
\name{summary}
\alias{summary}
\alias{summary,prosper-method}
\title{Summary for prosper objects}
\usage{
\S4method{summary}{prosper}(object, geneticSumCol = "SB_autumn_end", ...)
}
\arguments{
\item{object}{\code{prosper}, the result of a simulation with PROSPER.}

\item{geneticSumCol}{column name of the prosper object the genetic summary is built of. \code{character}.}

\item{...}{not in use.}
}
\value{
A named list of data.tables.
}
\description{
This function gives a first overview of a prosper simulation result.
}
\details{
For the population dynamic part, means and standard deviations per simulation cycle for every numeric variable is calculated. Variability is introduced by repetitions. Additionally, a simple overview on factorial variables is given. For further calculations the numbers of individuals for each simulation cycle and repetition are provided.

For the genetic part,  means and standard deviations of proportions of individuals with only sensitive alleles (allSalleles), only resistance alleles (allRalleles), mixed alleles (RSalleles), and the proportions of resistance alleles in the population (Ralleles) are calculated for each simulation cycle. The repetitions are responsible for the variability.
}
\examples{
data(param.LOLRI)
mod_lolri    <- prosper.LOLRI(param.weed=param.LOLRI, area=30, af = c(0.005, 0.01),
                                       duration=3, repetitions=2)
summary(mod_lolri)
}
\seealso{
\code{\link{plot}}
}
