% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circ.psa.R
\name{circ.psa}
\alias{circ.psa}
\title{Generates a Propensity Score Assessment Plot}
\usage{
circ.psa(
  response,
  treatment = NULL,
  strata = NULL,
  summary = FALSE,
  statistic = "mean",
  trim = 0,
  revc = FALSE,
  confint = TRUE,
  sw = 0.4,
  ne = 0.5,
  inc = 0.25,
  pw = 0.4,
  lab = TRUE,
  labcex = 1,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  mai = c(1, 1.7, 1, 1.7)
)
}
\arguments{
\item{response}{Either a numeric vector containing the response of interest
in a propensity score analysis, or a three column array containing response,
treatment and strata.}

\item{treatment}{Binary variable of same length as \code{response};
generally 0 for 'control,' 1 for 'treatment'.  A character vector with two
labels or factor with two levels are also accepted.}

\item{strata}{Generally integer variable; a vector of same length as
\code{response} indicating the derived strata from estimated propensity
scores. Generally 5 or 6 strata used, but function is effective for more
strata. In the case when strata are defined via unique propensity scores (as
from a tree), user may wish to define strata using \code{factor}.}

\item{summary}{Logical (default \code{FALSE}).  If \code{TRUE} then
\code{response} must have rows corresponding to number of strata; the first
two columns should contain treatment and control group sizes for each
stratum, and the pair of columns should contain the appropriate summary
statistics for each statum.  For example, the four summary columns might
have been generated by the \code{strata.summary} output of \code{loess.psa}.}

\item{statistic}{A scalar summary of the center of the response
distribution. Seen next item below.  Default = "mean".  Note that to
generate this statistic the full vector of responses must have been input,
not summaries.}

\item{trim}{Allows for a trimmed mean as outcome measure, where trim is from
0 to .5 (.5 implying median).}

\item{revc}{Logical; if \code{TRUE} then X and Y axes are interchanged in
plot.}

\item{confint}{Logical; if \code{TRUE} adds an approximate 95\% confidence
interval for the mean.  The interval may not be realistic it the \code{trim}
argument exceeds zero.}

\item{sw}{Numerical argument (default = 0.4); extends axes on lower ends,
effectively moving circles to lower left.}

\item{ne}{Numerical argument (default = 0.5); extends axes on upper ends,
effectively moving circles to upper right.}

\item{inc}{Numerical argument (default = 0.35); controls circle sizes, but
relative circle sizes are controlled via \code{pw}. In general one wants
circle areas to appear subjectively to be sized in accordance with strata
sizes.}

\item{pw}{numerical argument (default = 0.4); controls relative circle
sizes. \code{pw} denotes power or exponent for radius of circle.}

\item{lab}{Logical (default TRUE); labels circles with stratum labels.}

\item{labcex}{numerical argument (default = 1); controls the size of the
circle labels.}

\item{xlab}{Label for horizontal axis, by default taken from
\code{treatment}.}

\item{ylab}{Label for vertical axis, by default taken from \code{treatment}.}

\item{main}{Main label for graph.}

\item{mai}{margin parameters.}
}
\value{
Generate a Propensity Assessment Plot, as well as numerical data for
\item{summary.strata}{An array with rows corresponding to strata and four
columns; these show counts for control and treatment groups, as well as
(possibly trimmed) mean response values for control and treatment.}
\item{wtd.Mn.(Name1)}{Weighted mean of response for (Name1) group.  Name
taken from \code{treatment}.} \item{wtd.Mn.(Name2)}{Weighted mean of
response for (Name2) group.  Name taken from \code{treatment}.}
\item{ATE}{Average Treatment Effect.} \item{se.wtd}{Weighted standard error
for \code{ATE}} \item{approx.t}{Ratio of the average treatement effect and a
standard error based on weighting of stratum variances.} \item{df}{Estimate
of degree of freedom; response vector length minus twice number of strata.}
\item{CI.95}{Approximate 95\% confidence interval for overall effect size.}
}
\description{
Displays a graphic that summarizes outcomes in a propensity score analysis,
based on strata that have been defined in the first Phase of a propensity
score analysis (PSA).  The graphic displays contributions of individual
strata to the overall effect, weighing contributions of individual strata
according to the relative sizes of the respective strata. The overall effect
is plotted as a heavy dashed diagonal line that runs parallel to the
identity diagonal.
}
\details{
A circle is plotted for each stratum, centered on the means for the
treatment and control groups (for the \code{X} and \code{Y} axes)
respectively. The sizes of the circles correspond to the relative sizes of
the strata. A diagonal line (lower left to upper right) shows the identity,
\code{X=Y}, so that circles on, say, the lower side of this line show that
the corresponding \code{X} mean is larger than the \code{Y} mean for that
stratum, and vice-versa. Parallel projections are made from the centers of
the strata-cum-circles to difference scores that are plotted on a line
segment on the lower-left corner of the graphic; the average difference,
which corresponds to the average treatment effect (ATE) for the overall
treatment effect, is plotted as a heavy (dark blue) dashed line parallel to
the identity diagonal. Rug plots are shown on the upper and right margins of
the graphic, for the \code{X} and \code{Y} marginal distributions. A 95\%
confidence interval for the overall effect is plotted to the left of the
distribution of the stratum difference scores, centered on the ATE. Trimmed
means can replace the conventional mean for both the ATE and the marginal
distributions (however, the confidence interval calculations are likely to
become less trustworthy as larger values of the trim argument are used).
}
\examples{

##Random data with effect size 0
response <- rnorm(1000)
treatment <- sample(c(0,1), 1000, replace = TRUE)
strata <- sample(1:6, 1000, replace = TRUE)
circ.psa(response, treatment, strata)

##Random data with effect size -.2
response <- c(rnorm(500, 0, 12), rnorm(500, 6, 12))
treatment <- c(rep(0, 500), rep(1,500))
strata <- sample(1:5, 1000, replace = TRUE)
aaa <- cbind(response, treatment, strata)
circ.psa(aaa)

##Random data with effect size -2
response <- c(rt(100,3) * 2 + 20, rt(100,12) * 2 + 18)
treatment <- rep(c("A","B"), each = 100)
strata <- sample(c("X","Y","Z","U","V"), 200, replace = TRUE)
circ.psa(response, treatment, strata)

##Tree derived strata
library(rpart)
data(lindner)
attach(lindner)
lindner.rpart <- rpart(abcix ~ stent + height + female + diabetic +
     acutemi + ejecfrac + ves1proc, data = lindner, method = "class")
lindner.tree<-factor(lindner.rpart$where, labels = 1:6)
circ.psa(log(cardbill), abcix, lindner.tree)

##Loess derived strata
lindner.ps <- glm(abcix ~ stent + height + female +
      diabetic + acutemi + ejecfrac + ves1proc,
      data = lindner, family = binomial)
ps<-lindner.ps$fitted
lindner.loess<-loess.psa(log(cardbill), abcix, ps)
circ.psa(lindner.loess$summary.strata[, 1:4], summary = TRUE,
      inc = .1, labcex = .7)
}
\seealso{
\code{\link{loess.psa}}
}
\author{
James E. Helmreich \email{James.Helmreich@Marist.edu}

Robert M. Pruzek \email{RMPruzek@yahoo.com}
}
\keyword{hplot}
