% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLF.test.R
\name{MLF.test}
\alias{MLF.test}
\title{Modified Lilliefors Goodness-of-Fit Normality Test}
\usage{
MLF.test(x)
}
\arguments{
\item{x}{a numeric vector of data values, the number of which must be greater than 4.}
}
\value{
A list with class “htest” containing the following components:

\code{statistic} - the value of the modified Lilliefors statistic.

\code{p.value} - the p-value for the test.

\code{method} - the character string “Modified Lilliefors goodness-of-fit normality test”.

\code{data.name} - a character string giving the name(s) of the data.
}
\description{
Performs the modified Lilliefors goodness-of-fit normality test.
}
\details{
The modified Lilliefors goodness-of-fit normality test statistic, see formula (5) in the article.
}
\examples{
\donttest{MLF.test(rnorm(33, mean = 0, sd = 2))}
\donttest{MLF.test(data1)}

}
\references{
{Sulewski, P. (2019). \emph{Modified Lilliefors Goodness-of-fit Test for Normality.} Communications in Statistics - Simulation and Computation 51(3), 1199-1219.}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
