% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lms3.cv.R
\name{Lms3.cv}
\alias{Lms3.cv}
\title{Logarithmic minimum test for independence in three-way contingency table}
\usage{
Lms3.cv(nr, nc, nt, n, alfa, B = 10000)
}
\arguments{
\item{nr}{a number of rows}

\item{nc}{a number of columns}

\item{nt}{a number of tubes}

\item{n}{a sample size}

\item{alfa}{a significance level}

\item{B}{an integer specifying the number of replicates used in the Monte Carlo test (optional)}
}
\value{
The function returns the critical value of the logarithmic minimum test.
}
\description{
Calculates the critical value of the Logarithmic minimum test for independence in three-way contingency table
(see Sulewski P. (2018)).
}
\details{
The Critical value of the Logarithmic minimum test for independence in r x c x t contingency table,
}
\examples{
Lms3.cv(2, 2, 2, 80, 0.05, B = 1e2)
\donttest{Lms3.cv(2, 2, 2, 80, 0.1, B = 1e3)}

}
\references{
{Sulewski, P. (2021). \emph{Logarithmic Minimum Test for Independence in Three Way Con-tingency Table of Small Sizes,} Journal of Statistical Computation and Simulation 91(13), 2780-2799}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
