#' Harbour_metals
#'
#' @description The harbour metals data set contains several metal concentration measurements on 60 seaweed samples. Each sample is either of the Padina or Sargassum species and the samples were collected across five cites in Port Jackson (Australia).
#'
#' @docType data
#'
#' @name Harbour_metals
#'
#' @usage data(Harbour_metals)
#'
#' @format
#' A data frame with 60 observations and 7 variables, which are described as follows.
#' \describe{
#'   \item{Location}{Sample sites (Balls Head, Berrys Bay, Felix Bay, Hermit Bay, Neutral Bay)}
#'   \item{Species}{Seaweed species (Padina, Sargassum)}
#'   \item{Rep}{Unique labels for replicate samples}
#'   \item{Cd}{Cadmium (\eqn{\mu}g/g)}
#'   \item{Cr}{Chromium (\eqn{\mu}g/g)}
#'   \item{Cu}{Copper (\eqn{\mu}g/g)}
#'   \item{Mn}{Manganese (\eqn{\mu}g/g)}
#'   \item{Ni}{Nickel (\eqn{\mu}g/g)}
#'   \item{Pb}{Lead (\eqn{\mu}g/g)}
#'   \item{Zn}{Zinc (\eqn{\mu}g/g)}
#' }
#'
#' @keywords datasets
#'
#' @references Roberts, D.A., Johnston, E.L., Poore, A.G. (2008). Biomonitors and the assessment of ecological impacts: distribution of herbivorous epifauna in contaminated macroalgal beds. \emph{Environmental Pollution}, 156(2), 489-503.
#'
#' @source Dataset downloaded from Environmental Computing <https://environmentalcomputing.net/datasets/Harbour_metals.csv>.

#' @examples
#' data(Harbour_metals)
#'
"Harbour_metals"
