% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_power.R
\name{fit_bounded_logistic}
\alias{fit_bounded_logistic}
\title{Fit a bounded logistic curve}
\usage{
fit_bounded_logistic(x, y, wt)
}
\arguments{
\item{x}{The vector of covariate values of the logistics}

\item{y}{The proportion of 1s for a given value of x.  Same length as x.}

\item{wt}{The weight to place on a given x-y pair.  Same length as x, or
scalar.}
}
\value{
Vector of four estimated parameters for the logistic curve: beta0,
  beta1, pmin, pmax
}
\description{
Curve is of form f(y) = pmin + (pmax-pmin) * logistic( beta0 + beta1*x )
}
\details{
(logistic as defined by plogis)
Note that a logistic curve is not a perfect fit for the functional
form of the power curve, but is a useful approximation for
the search procedure.
}
\keyword{internal}
