% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pumpresult.R
\name{pumpresult}
\alias{pumpresult}
\alias{params}
\alias{d_m}
\alias{design}
\alias{search_path}
\alias{pump_type}
\alias{is.pumpresult}
\alias{[.pumpresult}
\alias{[[.pumpresult}
\alias{dim.pumpresult}
\alias{summary.pumpresult}
\alias{print.pumpresult}
\alias{as.data.frame.pumpresult}
\title{pumpresult object for results of power calculations}
\usage{
params(x, ...)

d_m(x, ...)

design(x, ...)

search_path(x, ...)

pump_type(x)

is.pumpresult(x)

\method{[}{pumpresult}(x, ...)

\method{[[}{pumpresult}(x, ...)

\method{dim}{pumpresult}(x, ...)

\method{summary}{pumpresult}(object, ...)

\method{print}{pumpresult}(x, n = 10, header = TRUE, search = FALSE, include_SE = TRUE, ...)

\method{as.data.frame}{pumpresult}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{a pumpresult object (except for is.pumpresult, 
where it is a generic object to check).}

\item{...}{additional arguments to be passed to the 
as.data.frame.list methods.}

\item{object}{Object to summarize.}

\item{n}{Number of lines of search path to print, max.}

\item{header}{FALSE means skip some header info on the result, just
print the data.frame of actual results.}

\item{search}{FALSE means don't print the search path for a result
for mdes or sample.}

\item{include_SE}{TRUE means include standard errors given design
(if any) in the printout.  Default to TRUE.}

\item{row.names}{NULL or a character vector giving the 
row names for the data frame.}

\item{optional}{logical. If TRUE, setting row names and 
converting column names is optional.}
}
\value{
params: List of design parameters used.

d_m: Context (d_m) used (as string).

design (the randomization and levels) as string.

search_path: Dataframe describing search path, 
if it was saved in the pumpresult object.

pump_type: power, mdes, or sample, as a string.

is.pumpresult: TRUE if object is a pumpresult object.

`[`: pull out rows and columns of the dataframe.

`[[`: pull out single element of dataframe.

dim: Dimension of pumpresult (as matrix)

summary: No return value; prints results.

print: No return value; prints results.

as.data.frame: pumpresult object as a clean 
dataframe (no more attributes from pumpresult).
}
\description{
The pumpresult object is an S3 class that holds the results from
`pump_power()`, 
`pump_sample()`, and `pump_mdes()`.

It has several methods that pull different information from this object, and
some printing methods for getting nicely formatted results.

Pump result objects are also data.frames, so they can be easily manipulated
and combined.  The return values from the `grid` functions will just return
data frames in general.

Returns whether call was power, mdes, or sample.

Calls the print_context method with results and control both set to TRUE.
}
\examples{
pp <- pump_power(d_m = "d3.2_m3ff2rc",
  MTP = 'HO', nbar = 50, J = 30, K = 10,
  M = 5, MDES = 0.125, Tbar = 0.5, alpha = 0.05,
  numCovar.1 = 1, numCovar.2 = 1,
  R2.1 = 0.1, R2.2 = 0.1, ICC.2 = 0.2, ICC.3 = 0.2,
  omega.2 = 0, omega.3 = 0.1, rho = 0.5, tnum = 1000)
  
print(pp)
params(pp)
print_context(pp)
d_m(pp)
pump_type(pp)
is.pumpresult(pp)
as.data.frame(pp)
dim(pp)
summary(pp)
transpose_power_table(pp)

J <- pump_sample(d_m = "d2.1_m2fc",
  MTP = 'HO', power.definition = 'D1indiv',
  typesample = 'J', target.power = 0.7,
  nbar = 50, M = 3, MDES = 0.125,
  Tbar = 0.5, alpha = 0.05, numCovar.1 = 1,
  R2.1 = 0.1, ICC.2 = 0.05, rho = 0.2, tnum = 1000)
  
search_path(J)
power_curve(J)   
}
\seealso{
update

update_grid

print_context

print_context
}
