% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceMethods.R
\name{gs_vertex_attr<-,PathwaySpace-method}
\alias{gs_vertex_attr<-,PathwaySpace-method}
\alias{gs_vertex_attr<-}
\alias{gs_edge_attr<-,PathwaySpace-method}
\alias{gs_edge_attr<-}
\title{Accessor Functions for PathwaySpace Objects}
\usage{
\S4method{gs_vertex_attr}{PathwaySpace}(x, name, ...) <- value

\S4method{gs_edge_attr}{PathwaySpace}(x, name, ...) <- value
}
\arguments{
\item{x}{A \linkS4class{PathwaySpace} class object.}

\item{name}{Name of the attribute.}

\item{...}{Additional arguments passed to igraph methods.}

\item{value}{The new value of the attribute.}
}
\value{
Updated \linkS4class{PathwaySpace} object.
}
\description{
Get or set edge and vertex attributes in
\linkS4class{PathwaySpace} class object.
}
\examples{
data('gtoy1', package = 'RGraphSpace')
ps <- buildPathwaySpace(gtoy1, nrc = 100)

# Get vertex count
gs_vcount(ps)

# Get edge count
gs_ecount(ps)

# Access a specific vertex attribute
gs_vertex_attr(ps, "signal")

# Replace an entire vertex attribute
gs_vertex_attr(ps, "signal") <- 1

# Modify a single value within a vertex attribute
gs_vertex_attr(ps, "signal")["n1"] <- 1

# Access a specific edge attribute
gs_edge_attr(ps, "weight")

# Replace an entire edge attribute
gs_edge_attr(ps, "weight") <- 1

}
