% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{peng_df}
\alias{peng_df}
\title{Size Measurements for Penguins near Palmer Station, Antarctica}
\format{
A data frame with 333 observations and 8 variables:
\describe{
  \item{species}{Penguin species (factor with 3 levels).}
  \item{island}{Island of observation (factor with 3 levels).}
  \item{bill_length}{Bill length in millimeters (numeric).}
  \item{bill_depth}{Bill depth in millimeters (numeric).}
  \item{flipper_length}{Flipper length in millimeters (integer).}
  \item{body_mass}{Body mass in grams (integer).}
  \item{sex}{Sex of the penguin (factor with 2 levels).}
  \item{year}{Year of observation (integer).}
}
}
\source{
Data taken from the heplots package version 1.7.8
}
\usage{
data(peng_df)
}
\description{
This dataset, peng_df, is a data frame containing morphometric measurements
for penguins observed near Palmer Station in the Palmer Archipelago, Antarctica.
It includes data on three species across multiple islands, with variables for
bill dimensions, flipper length, body mass, sex, and year of observation.
Some observations may contain missing values.
}
\details{
The data were originally sourced from the palmerpenguins dataset and are provided
in the heplots package for illustrative and educational use in multivariate
statistical analysis examples.

The dataset name has been kept as 'peng_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
PenguinR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
