% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankEN.R
\name{extract_ranked}
\alias{extract_ranked}
\title{Extract candidate compounds}
\usage{
extract_ranked(rankEN_obj, include_cor = TRUE)
}
\arguments{
\item{rankEN_obj}{An object of class \code{rankEN}.}

\item{include_cor}{Either \code{TRUE} or \code{FALSE}, specifying whether a
column should be included in the returning \code{data.frame} providing
the correlation between the compound and the within-fraction average of
the bioactivity replicates in the region of interest.}
}
\description{
Extract an ordered list of candidate compounds from a \code{rankEN} object.
The list is presented in the form of a \code{data.frame}, such that each row
provides the identifying information for a particular candidate compound, and
with the rows arranged in the order that the compounds entered the elastic
net model (i.e. row 1 is the earliest, row 2 the 2nd earliest, etc.).  The
columns of the \code{data.frame} provide the mass-to-charge information,
charge information, and possibly the correlation between the compound and the
within-fraction average of the bioactivity replicates in the region of
interest.
}

