% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dhCGF_plot1D.R
\name{Univariate_CGF_plot}
\alias{Univariate_CGF_plot}
\alias{dhCGF_plot1D}
\title{Graphical plots to assess multivariate univarite assumption of data.}
\usage{
dhCGF_plot1D(x, alpha = 0.05, method)
}
\arguments{
\item{x}{Univariate data}

\item{alpha}{Significant level (default is \eqn{.05})}

\item{method}{string, \code{"T3"} used the third derivatives,
and \code{"T4"} uses the fourth derivatives.}
}
\value{
Plots
}
\description{
Plots the empirical third/fourth derivatives of cumulant generating function
together with confidence probability region.
Indication of non-normality is either violation of probability bands or
curves with high slope.
}
\examples{
set.seed(123)
x <- rnorm(100)
dhCGF_plot1D(x, method = "T3")
dhCGF_plot1D(x, method = "T4")

}
\references{
\insertRef{ref:ghoshuni}{PlotNormTest}
}
