% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsClinicalTrial.R
\name{ClinicalTrial}
\alias{ClinicalTrial}
\title{Clinical trial: estimation of case-count efficacy}
\usage{
ClinicalTrial(vaccinated, control, CI = 0.95)
}
\arguments{
\item{vaccinated}{\code{Population-class} object: vaccinated subjects with assigned PoD}

\item{control}{\code{Population-class} object: control subjects with assigned PoD}

\item{CI}{numeric: value from (0, 1) interval, confidence level of interest}
}
\value{
\itemize{
  \item vaccinated: vaccinated subjects with assigned DS, \code{Population-class} object

  \item control: control subjects with assigned DS, \code{Population-class} object

  \item efficacy: case-count efficacy

  \item confidenceInterval: case-count efficacy confidence interval calculated with \code{waldCI()} function
}
}
\description{
Function assigns disease status (DS) to vaccinated and control groups and based on that calculates the case-count efficacy. Vaccinated and control groups are provided in the form of population class objects (see the \code{Population-class} function for more details).

Input populations need to contain information about Probability of disease (PoD) for each subject - calculated using \code{population$assignPoD(PoD(x))}. See \code{PoD} function for further details.
}
\examples{
# Loading vaccinated, control population data with PoD information
data(vaccinated)
data(control)

# Estimating the disease status and case-count efficacy with 95\\% confidence interval
CT <- ClinicalTrial(vaccinated, control, CI = 0.95)

CT$efficacy
CT$confidenceInterval

CT$vaccinated

}
