% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsPoDParameters.R
\name{PmaxEstimation}
\alias{PmaxEstimation}
\title{PoD curve paramater, pmax,  estimation}
\usage{
PmaxEstimation(IncidenceRate,
               params, 
               control,
               adjustTiters = FALSE, 
               adjustFrom = NA, 
               adjustTo = NA)
}
\arguments{
\item{IncidenceRate}{numeric: observed incidence rate in overall (control) subjects}

\item{params}{numeric vector: et50 and slope}

\item{control}{\code{Population-class} object: control subjects (mean, sd)}

\item{adjustTiters}{boolean: set to TRUE if titer values should be adjusted, for details see \code{PoD} function}

\item{adjustFrom}{numeric: value specifying the detection limit, all values below the detection limit will be adjusted to adjustTo value}

\item{adjustTo}{numeric: value to which titers below the detection limit will be adjusted}
}
\value{
PoD curve parameter pmax
}
\description{
Function finds the pmax parameter of the PoD curve using control subjects summary statistics (mean, sd), observed incidence rate and previsouly estimated et50 and slope by \code{PoDEfficacySquaredError} function.
}
\examples{

## Example 1
data(vaccinated)
data(control)

# Assigning true efficacy 
TrueEfficacy <- 0.53

# PoD curve parameters (et50, slope) estimation
params <- PoDEfficacySquaredError(TrueEfficacy, vaccinated, control)

# Assigning incidence rate (observed incidence rate)
IncidenceRate <- 0.2

# pmax estimation
pmax <- PmaxEstimation(IncidenceRate, params, control)

# combining PoD curve parameters
PoDParams <- unlist(c(params, pmax))

}
