% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{consensus}
\alias{consensus}
\title{Policy portfolios for the dataset of the CONSENSUS research project.}
\format{
A data frame (tibble) containing the coverage of state intervention in a specific policy space (presence = 1 or absence = 0) for the CONSENSUS research project. It covers 23 countries in two sectors (Environmental, with 49 Targets and 11 Instruments; and Social, with 19 Targets and 6 Instruments) between 1976 and 2005.
}
\source{
Consensus research project (217239): https://cordis.europa.eu/project/id/217239
}
\usage{
data(consensus)
}
\description{
A tidy dataset of a policy portfolios in social and environmental policies for the CONSENSUS research project.
}
\details{
When using the dataset, please cite:

Fernández-i-Marín, X., Knill, C. & Steinebach, Y. (2021). Studying Policy Design Quality in Comparative Perspective. _American Political Science Review_, online first.

Knill, C., Schulze, K. & Tosun, J. (2012). Regulatory Policy Outputs and Impacts. Exploring a Complex Relationship. _Regulation & Governance_, 5(4), 427-444. doi:10.1111/j.1748-5991.2012.01150.x.
}
\examples{
data(consensus)
str(consensus)
}
\references{
Fernández-i-Marín, X., Knill, C. & Steinebach, Y. (2021). Studying Policy Design Quality in Comparative Perspective. _American Political Science Review_, online first.

Knill, C., Schulze, K. & Tosun, J. (2012). Regulatory Policy Outputs and Impacts. Exploring a Complex Relationship. _Regulation & Governance_, 5(4), 427-444. doi:10.1111/j.1748-5991.2012.01150.x.
}
\seealso{
\code{\link{consensus.instruments}} and \code{\link{consensus.targets}} for meta data about Instrument id and types, and Target id and Subsector.
}
\keyword{datasets}
