% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f21hyper.R
\name{f21hyper}
\alias{f21hyper}
\title{f21hyper}
\usage{
f21hyper(a, b, c, z)
}
\arguments{
\item{a}{The parameter \code{a} of the Gaussian hypergeometric function, must be a positive scalar here}

\item{b}{The parameter \code{b} of the Gaussian hypergeometric function, must be a positive scalar here}

\item{c}{The parameter \code{c} of the Gaussian hypergeometric function, must be a positive scalar here}

\item{z}{The parameter \code{z} of the Gaussian hypergeometric function, must be between -1 and 1 here}
}
\value{


Invalid arguments will return an error message.
}
\description{
Computes the value of a Gaussian hypergeometric function \eqn{ F(a,b,c,z) } for \eqn{-1 \leq z \leq 1} and \eqn{a,b,c \geq 0}
}
\details{
The function \code{f21hyper} complements the analysis of the 'hyper-g prior' introduced by Liang et al. (2008).\cr
For parameter values, compare cf. \url{https://en.wikipedia.org/wiki/Hypergeometric_function#The_series_2F1}.
}
\examples{
f21hyper(30,1,20,.8) #returns about 165.8197
f21hyper(30,10,20,0) #returns one
f21hyper(10,15,20,-0.1) # returns about 0.4872972





}
\references{
Liang F., Paulo R., Molina G., Clyde M., Berger J.(2008): Mixtures of g-priors for Bayesian variable selection. J. Am. Statist. Assoc. 103, p. 410-423

Yuancheng Si and Saralees Nadarajah and Xiaodong Song, (2020). On the distribution of quotient of random variables conditioned to the positive quadrant. \emph{Communications in Statistics - Theory and Methods}, \bold{49}, pp2514-2528.


Saralees Nadarajah and Y.Si (2020) A note on the “L-logistic regression models: Prior sensitivity analysis, robustness to outliers and applications”. \emph{Brazilian Journal of Probability and Statistics},\bold{34},p. 183-187.
}
\author{
Martin Feldkircher and Stefan Zeugner
}
