% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.simultaneous_ci_result}
\alias{plot.simultaneous_ci_result}
\title{Plot Simultaneous Confidence Intervals}
\usage{
\method{plot}{simultaneous_ci_result}(
  x,
  y = NULL,
  subset_pars = NULL,
  log.scale = FALSE,
  cex = 0.8,
  cex.labels = 0.8,
  las.labels = 1,
  pch = 16,
  col.estimate = "blue",
  col.ci = "darkgray",
  col.ref = "red",
  ref.line.pos = 0,
  lty.ref = 2,
  main = "Simultaneous Confidence Intervals",
  xlab = NULL,
  label.trim = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{simultaneous_ci_result}, typically returned by \code{simultaneous_ci()}.}

\item{y}{Ignored.}

\item{subset_pars}{Optional character vector. Coefficient names to subset the plot. Default: all.}

\item{log.scale}{Logical. Plot on logarithmic scale. Intervals crossing 0 or with nonpositive bounds are excluded.}

\item{cex}{Point size for estimates. Default = 0.8.}

\item{cex.labels}{Label size for y-axis. Default = 0.8.}

\item{las.labels}{Orientation of y-axis labels (0, 1, 2, or 3). Default = 1.}

\item{pch}{Plot character for point estimates. Default = 16.}

\item{col.estimate}{Color of point estimates. Default = "blue".}

\item{col.ci}{Color of confidence interval lines. Default = "darkgray".}

\item{col.ref}{Color of reference line(s). Default = "red".}

\item{ref.line.pos}{Position(s) for vertical reference line(s). Default = 0. Set to NULL to omit.}

\item{lty.ref}{Line type for reference lines. Default = 2 (dashed).}

\item{main}{Plot title. Default = "Simultaneous Confidence Intervals".}

\item{xlab}{X-axis label. If NULL and \code{log.scale = TRUE}, label defaults to "Log Estimate".}

\item{label.trim}{Integer. Trims long coefficient labels to this width (adds "..."). Optional.}

\item{...}{Additional arguments passed for future use (currently ignored).}
}
\value{
Invisibly returns a list:
\itemize{
\item \code{ycoords}: Named vector of y-axis positions for each label
\item \code{xlim}: Range of x-axis limits used
\item \code{ylim}: Range of y-axis limits used
}

If no valid intervals are available for plotting, returns \code{invisible(NULL)}.
}
\description{
Visualizes confidence intervals returned by \code{simultaneous_ci()} using base R graphics.
Estimates are shown as points with corresponding CI segments, grouped and labeled by
model and coefficient name. Supports customization for log scale, character sizes,
label trimming, and reference lines.
}
\examples{
set.seed(1)
X <- matrix(rnorm(100*2), 100, 2, dimnames = list(NULL, c("X1", "X2")))
y <- 1 + X[,1] - X[,2] + rnorm(100)
res <- simultaneous_ci(X, y, list(mod = 1:3), B = 100, add_intercept = TRUE)
plot(res)
}
